/*
 * Decompiled with CFR 0.152.
 */
package lemmini.extract;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import org.apache.commons.lang3.BooleanUtils;

class DATSection {
    private static final int HEADER_SIZE = 10;
    private final byte[] compressedData;
    private final int numBitsInFirstByte;
    private final int decompressedDataSize;
    private int index;
    private int bitIndex;

    DATSection(byte[] compressedData, int numBitsInFirstByte, int decompressedDataSize) {
        this.compressedData = compressedData;
        this.numBitsInFirstByte = numBitsInFirstByte;
        this.decompressedDataSize = decompressedDataSize;
        this.resetIndex();
    }

    static DATSection getDATSection(ByteChannel bc) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        if (bc.read(buffer) != 10) {
            return null;
        }
        buffer.rewind();
        byte numBitsInFirstByte = buffer.get();
        byte targetChecksum = buffer.get();
        int decompressedDataSize = buffer.getInt();
        int compressedDataSize = buffer.getInt() - 10;
        if (numBitsInFirstByte < 0 || numBitsInFirstByte > 8) {
            return null;
        }
        buffer = ByteBuffer.allocate(compressedDataSize);
        if (bc.read(buffer) != compressedDataSize) {
            return null;
        }
        byte[] compressedData = buffer.array();
        byte sectionChecksum = 0;
        byte[] byArray = compressedData;
        int n = compressedData.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sectionChecksum = (byte)(sectionChecksum ^ b);
            ++n2;
        }
        if (sectionChecksum != targetChecksum) {
            return null;
        }
        return new DATSection(compressedData, numBitsInFirstByte, decompressedDataSize);
    }

    byte[] decompress() {
        byte[] decompressedData = new byte[this.decompressedDataSize];
        int dIndex = decompressedData.length - 1;
        while (dIndex >= 0) {
            block0 : switch (this.nextValue(1)) {
                case 0: {
                    int offset;
                    int byteCount;
                    switch (this.nextValue(1)) {
                        case 0: {
                            byteCount = this.nextValue(3) + 1;
                            this.extractBytes(decompressedData, dIndex, byteCount);
                            dIndex -= byteCount;
                            break block0;
                        }
                        case 1: {
                            offset = this.nextValue(8) + 1;
                            this.copyBytes(decompressedData, dIndex, 2, offset);
                            dIndex -= 2;
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    int offset;
                    int byteCount;
                    switch (this.nextValue(2)) {
                        case 0: {
                            offset = this.nextValue(9) + 1;
                            this.copyBytes(decompressedData, dIndex, 3, offset);
                            dIndex -= 3;
                            break block0;
                        }
                        case 1: {
                            offset = this.nextValue(10) + 1;
                            this.copyBytes(decompressedData, dIndex, 4, offset);
                            dIndex -= 4;
                            break block0;
                        }
                        case 2: {
                            byteCount = this.nextValue(8) + 1;
                            offset = this.nextValue(12) + 1;
                            this.copyBytes(decompressedData, dIndex, byteCount, offset);
                            dIndex -= byteCount;
                            break block0;
                        }
                        case 3: {
                            byteCount = this.nextValue(8) + 9;
                            this.extractBytes(decompressedData, dIndex, byteCount);
                            dIndex -= byteCount;
                            break block0;
                        }
                    }
                    break;
                }
            }
        }
        this.resetIndex();
        return decompressedData;
    }

    private void resetIndex() {
        this.index = this.compressedData.length - (this.numBitsInFirstByte == 0 ? 2 : 1);
        this.bitIndex = 0;
    }

    private boolean nextBit() {
        boolean retBool = BooleanUtils.toBoolean((int)(this.compressedData[this.index] & 1 << this.bitIndex));
        ++this.bitIndex;
        if (this.bitIndex >= 8 || this.index == this.compressedData.length - 1 && this.bitIndex >= this.numBitsInFirstByte) {
            --this.index;
            this.bitIndex = 0;
        }
        return retBool;
    }

    private int nextValue(int size) {
        int retValue = 0;
        int i = size - 1;
        while (i >= 0) {
            retValue |= (this.nextBit() ? 1 : 0) << i;
            --i;
        }
        return retValue;
    }

    private byte nextByte() {
        return (byte)this.nextValue(8);
    }

    private void extractBytes(byte[] data, int idx, int count) {
        int i = 0;
        while (i < count) {
            data[idx--] = this.nextByte();
            ++i;
        }
    }

    private void copyBytes(byte[] data, int idx, int count, int offset) {
        if (offset >= count) {
            System.arraycopy(data, idx + offset - (count - 1), data, idx - (count - 1), count);
        } else {
            int i = 0;
            while (i < count) {
                data[idx] = data[idx + offset];
                --idx;
                ++i;
            }
        }
    }
}

