/*
 * Decompiled with CFR 0.152.
 */
package lemmini;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.GroupLayout;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import lemmini.LemminiFrame;
import lemmini.game.Core;
import lemmini.game.GameController;
import lemmini.game.Icons;
import lemmini.game.LemmCursor;
import lemmini.game.LemmException;
import lemmini.game.LemmFont;
import lemmini.game.Lemming;
import lemmini.game.Level;
import lemmini.game.LevelCode;
import lemmini.game.LevelPack;
import lemmini.game.Minimap;
import lemmini.game.MiscGfx;
import lemmini.game.Player;
import lemmini.game.ReplayLevelInfo;
import lemmini.game.SpriteObject;
import lemmini.game.Stencil;
import lemmini.game.TextScreen;
import lemmini.gameutil.Fader;
import lemmini.graphics.GraphicsBuffer;
import lemmini.graphics.GraphicsContext;
import lemmini.graphics.LemmImage;
import lemmini.gui.LevelCodeDialog;
import lemmini.gui.LevelDialog;
import lemmini.gui.OptionsDialog;
import lemmini.gui.PlayerDialog;
import lemmini.tools.ToolBox;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;

public class LemminiPanel
extends JPanel
implements Runnable {
    private static final long serialVersionUID = 1L;
    static final int X_STEP = 4;
    static final int X_STEP_FAST = 16;
    static final int AUTOSCROLL_RANGE = 20;
    static final int SCORE_Y = 320;
    static final int COUNTER_X = 32;
    static final int COUNTER_Y = 360;
    static final int ICONS_X = 32;
    static final int ICONS_Y = 374;
    static final int SMALL_X = 528;
    static final int SMALL_Y = 374;
    private int menuOffsetX;
    private int mouseDragStartX;
    private int mouseDragStartY;
    private int xMouse;
    private int xMouseScreen;
    private int yMouse;
    private int yMouseScreen;
    private int mouseDx;
    private int mouseDy;
    private boolean shiftPressed = false;
    private boolean controlPressed;
    private boolean altPressed;
    private boolean leftPressed;
    private boolean rightPressed;
    private boolean upPressed;
    private boolean downPressed;
    private boolean draw;
    private boolean isFocused = true;
    private boolean mouseHasEntered = true;
    private boolean holdingMinimap = false;
    private boolean showDebugCursorInfo;
    private int drawBrushSize;
    private GraphicsBuffer outStrBuffer;
    private GraphicsBuffer offBuffer;
    private final Object paintSemaphore = new Object();
    private boolean drawNextFrame;
    private int unmaximizedWidth = 0;
    private int unmaximizedHeight = 0;
    private boolean replaySaved = false;

    private boolean needVLockIcon() {
        return GameController.getLevel() != null && GameController.getLevel().getHeight() > 320;
    }

    private int getIconBarX() {
        if (GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR)) {
            if (!this.needVLockIcon()) {
                return 22;
            }
            return 0;
        }
        return 42;
    }

    private int getIconBarY() {
        if (GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR)) {
            return 364;
        }
        return 374;
    }

    private int getSmallX() {
        if (GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR)) {
            return 538;
        }
        return 528;
    }

    private int getSmallY() {
        if (GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR)) {
            return 371;
        }
        return 374;
    }

    public LemminiPanel() {
        this.initComponents();
        this.unmaximizedWidth = this.getWidth();
        this.unmaximizedHeight = this.getHeight();
    }

    void init() {
        this.setBufferSize(Core.unscale(this.getWidth()), Core.unscale(this.getHeight()));
    }

    private void initComponents() {
        this.setBackground(new Color(0, 0, 0));
        this.setMinimumSize(new Dimension(800, 450));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                LemminiPanel.this.formMouseDragged(evt);
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                LemminiPanel.this.formMouseMoved(evt);
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent evt) {
                LemminiPanel.this.formMouseWheelMoved(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                LemminiPanel.this.formMouseEntered(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                LemminiPanel.this.formMouseExited(evt);
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                LemminiPanel.this.formMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                LemminiPanel.this.formMouseReleased(evt);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                LemminiPanel.this.formComponentResized(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 800, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 450, Short.MAX_VALUE));
    }

    private void formComponentResized(ComponentEvent evt) {
        this.mouseHasEntered = false;
        this.setSize(this.getWidth(), this.getHeight());
    }

    private void formMouseEntered(MouseEvent evt) {
        this.mouseDx = 0;
        this.mouseDy = 0;
        int x = Core.unscale(evt.getX());
        int y = Core.unscale(evt.getY());
        LemmCursor.setX(x);
        LemmCursor.setY(y);
        if (this.isFocused) {
            this.mouseHasEntered = true;
        }
    }

    private void formMouseExited(MouseEvent evt) {
        switch (GameController.getGameState()) {
            case BRIEFING: 
            case LEVEL: 
            case DEBRIEFING: {
                int x = this.xMouseScreen + Core.scale(this.mouseDx);
                if (x >= this.getWidth()) {
                    x = this.getWidth() - 1;
                }
                if (x < 0) {
                    x = 0;
                }
                this.xMouseScreen = x;
                this.xMouse = x = Core.unscale(x) + GameController.getXPos();
                LemmCursor.setX(Core.unscale(this.xMouseScreen));
                int y = this.yMouseScreen + Core.scale(this.mouseDy);
                if (y >= this.getHeight()) {
                    y = this.getHeight() - 1;
                }
                if (y < 0) {
                    y = 0;
                }
                this.yMouseScreen = y;
                this.yMouse = y = Core.unscale(y) + GameController.getYPos();
                LemmCursor.setY(Core.unscale(this.yMouseScreen));
                evt.consume();
                break;
            }
        }
    }

    private void formMousePressed(MouseEvent evt) {
        int x = Core.unscale(evt.getX());
        int y = Core.unscale(evt.getY());
        this.mouseDx = 0;
        this.mouseDy = 0;
        boolean swapButtons = GameController.isOptionEnabled(GameController.Option.SWAP_BUTTONS);
        int buttonPressed = evt.getButton();
        int modifiers = evt.getModifiersEx();
        boolean leftMousePressed = BooleanUtils.toBoolean((int)(modifiers & 0x400));
        boolean rightMousePressed = BooleanUtils.toBoolean((int)(modifiers & 0x1000));
        if (Fader.getState() != Fader.State.OFF && GameController.getGameState() != GameController.State.LEVEL) {
            return;
        }
        switch (GameController.getGameState()) {
            case INTRO: {
                if (buttonPressed != 1) break;
                TextScreen.Button button = TextScreen.getDialog().handleLeftClick(x - Core.getDrawWidth() / 2, y - Core.getDrawHeight() / 2);
                switch (button) {
                    case PLAY_LEVEL: 
                    case NONE: {
                        this.loadDefaultLevel();
                        break;
                    }
                    case CHOOSE_LEVEL: {
                        this.handleChooseLevel();
                        TextScreen.getDialog().handleMouseReleased();
                        break;
                    }
                    case LOAD_REPLAY: {
                        this.handleLoadReplay();
                        TextScreen.getDialog().handleMouseReleased();
                        break;
                    }
                    case ENTER_CODE: {
                        this.handleEnterCode();
                        TextScreen.getDialog().handleMouseReleased();
                        break;
                    }
                    case PLAYERS: {
                        this.handlePlayers();
                        TextScreen.getDialog().handleMouseReleased();
                        break;
                    }
                    case OPTIONS: {
                        this.handleOptions();
                        TextScreen.getDialog().handleMouseReleased();
                        break;
                    }
                    case ABOUT: {
                        this.getParentFrame().handleAbout();
                        TextScreen.getDialog().handleMouseReleased();
                        break;
                    }
                    case EXIT: {
                        this.getParentFrame().exit();
                        break;
                    }
                }
                evt.consume();
                break;
            }
            case BRIEFING: {
                if (buttonPressed == 1) {
                    TextScreen.Button button = TextScreen.getDialog().handleLeftClick(x - Core.getDrawWidth() / 2, y - Core.getDrawHeight() / 2);
                    switch (button) {
                        case SHOW_HINT: {
                            TextScreen.showHint();
                            break;
                        }
                        case SHOW_INFO: {
                            TextScreen.showLevelInfo();
                            break;
                        }
                        case NEXT_HINT: {
                            TextScreen.nextHint();
                            break;
                        }
                        case PREVIOUS_HINT: {
                            TextScreen.previousHint();
                            break;
                        }
                        case START_LEVEL: 
                        case NONE: {
                            this.startLevel();
                            break;
                        }
                        case MENU: {
                            this.exitToMenu();
                            break;
                        }
                    }
                    evt.consume();
                    break;
                }
                if (buttonPressed != 3) break;
                this.exitToMenu();
                evt.consume();
                break;
            }
            case DEBRIEFING: {
                if (buttonPressed == 1) {
                    TextScreen.Button button = TextScreen.getDialog().handleLeftClick(x - Core.getDrawWidth() / 2, y - Core.getDrawHeight() / 2);
                    switch (button) {
                        case CONTINUE: 
                        case NONE: {
                            this.findBestLevelToLoad();
                            break;
                        }
                        case RESTART: {
                            GameController.requestRestartLevel(false, true);
                            break;
                        }
                        case MENU: {
                            GameController.setTransition(GameController.TransitionState.TO_INTRO);
                            Fader.setState(Fader.State.OUT);
                            Core.setTitle("RetroLemmini");
                            break;
                        }
                        case REPLAY: {
                            GameController.requestRestartLevel(true, true);
                            break;
                        }
                        case SAVE_REPLAY: {
                            this.handleSaveReplay();
                            break;
                        }
                    }
                    evt.consume();
                    break;
                }
                if (buttonPressed != 3) break;
                this.exitToMenu();
                evt.consume();
                break;
            }
            case LEVEL: {
                if (leftMousePressed || rightMousePressed) {
                    this.debugDraw(x, y, leftMousePressed);
                }
                if (buttonPressed == 1) {
                    if (y >= this.getIconBarY() && y < this.getIconBarY() + Icons.getIconHeight()) {
                        Icons.IconType type = GameController.getIconType(x - this.menuOffsetX - this.getIconBarX());
                        if (type != null) {
                            GameController.handleIconButton(type);
                        }
                    } else {
                        Lemming l = GameController.lemmUnderCursor(LemmCursor.getType());
                        if (l != null) {
                            GameController.requestSkill(l);
                        } else if (y < 320) {
                            GameController.stopReplayMode();
                            if (!GameController.isOptionEnabled(GameController.SLTooOption.DISABLE_FRAME_STEPPING)) {
                                GameController.advanceFrame();
                            }
                        }
                    }
                    if (x >= this.getSmallX() + this.menuOffsetX && x < this.getSmallX() + this.menuOffsetX + Minimap.getVisibleWidth() && y >= this.getSmallY() && y < this.getSmallY() + Minimap.getVisibleHeight()) {
                        this.holdingMinimap = true;
                    }
                    evt.consume();
                }
                if (buttonPressed == (swapButtons ? 2 : 3)) {
                    switch (LemmCursor.getType()) {
                        case NORMAL: {
                            this.setCursor(LemmCursor.CursorType.WALKER);
                            break;
                        }
                        case LEFT: {
                            this.setCursor(LemmCursor.CursorType.WALKER_LEFT);
                            break;
                        }
                        case RIGHT: {
                            this.setCursor(LemmCursor.CursorType.WALKER_RIGHT);
                            break;
                        }
                    }
                    this.shiftPressed = true;
                }
                if (buttonPressed == 4) {
                    GameController.pressMinus(2);
                }
                if (buttonPressed != 5) break;
                GameController.pressPlus(2);
                break;
            }
        }
    }

    private void formMouseReleased(MouseEvent evt) {
        int x = Core.unscale(evt.getX());
        int y = Core.unscale(evt.getY());
        this.mouseDx = 0;
        this.mouseDy = 0;
        boolean swapButtons = GameController.isOptionEnabled(GameController.Option.SWAP_BUTTONS);
        int buttonPressed = evt.getButton();
        switch (GameController.getGameState()) {
            case LEVEL: {
                if (buttonPressed == 1) {
                    Icons.IconType type;
                    this.holdingMinimap = false;
                    if (y > this.getIconBarY() && y < this.getIconBarY() + Icons.getIconHeight() && (type = GameController.getIconType(x - this.menuOffsetX - this.getIconBarX())) != null) {
                        GameController.releaseIcon(type);
                    }
                    GameController.releasePlus(1);
                    GameController.releaseMinus(1);
                    GameController.releaseIcon(Icons.IconType.MINUS);
                    GameController.releaseIcon(Icons.IconType.PLUS);
                    GameController.releaseIcon(Icons.IconType.NUKE);
                    GameController.releaseIcon(Icons.IconType.RESTART);
                }
                if (buttonPressed == (swapButtons ? 2 : 3)) {
                    switch (LemmCursor.getType()) {
                        case WALKER: {
                            this.setCursor(LemmCursor.CursorType.NORMAL);
                            break;
                        }
                        case WALKER_LEFT: {
                            this.setCursor(LemmCursor.CursorType.LEFT);
                            break;
                        }
                        case WALKER_RIGHT: {
                            this.setCursor(LemmCursor.CursorType.RIGHT);
                            break;
                        }
                    }
                    this.shiftPressed = false;
                }
                if (buttonPressed == 4) {
                    GameController.releaseMinus(2);
                }
                if (buttonPressed == 5) {
                    GameController.releasePlus(2);
                }
                evt.consume();
                break;
            }
            case INTRO: {
                TextScreen.getDialog().handleMouseReleased();
                break;
            }
        }
    }

    private void formMouseDragged(MouseEvent evt) {
        int modifiers = evt.getModifiersEx();
        boolean leftMousePressed = BooleanUtils.toBoolean((int)(modifiers & 0x400));
        boolean middleMousePressed = BooleanUtils.toBoolean((int)(modifiers & 0x800));
        boolean rightMousePressed = BooleanUtils.toBoolean((int)(modifiers & 0x1000));
        this.mouseDx = 0;
        this.mouseDy = 0;
        switch (GameController.getGameState()) {
            case LEVEL: {
                int x = Core.unscale(evt.getX());
                int y = Core.unscale(evt.getY());
                if (GameController.isOptionEnabled(GameController.Option.SWAP_BUTTONS) ? rightMousePressed : middleMousePressed) {
                    int xOfsTemp = GameController.getXPos() + (x - this.mouseDragStartX);
                    GameController.setXPos(xOfsTemp);
                    if (!GameController.isVerticalLock()) {
                        int yOfsTemp = GameController.getYPos() + (y - this.mouseDragStartY);
                        GameController.setYPos(yOfsTemp);
                    }
                    Minimap.adjustXPos();
                }
                if (leftMousePressed || rightMousePressed) {
                    this.debugDraw(x, y, leftMousePressed);
                }
                this.formMouseMoved(evt);
                evt.consume();
                break;
            }
        }
    }

    private void formMouseMoved(MouseEvent evt) {
        int oldX = this.xMouse;
        int oldY = this.yMouse;
        this.xMouse = Core.unscale(evt.getX()) + GameController.getXPos();
        this.yMouse = Core.unscale(evt.getY()) + GameController.getYPos();
        this.xMouseScreen = evt.getX();
        if (this.xMouseScreen >= this.getWidth()) {
            this.xMouseScreen = this.getWidth();
        } else if (this.xMouseScreen < 0) {
            this.xMouseScreen = 0;
        }
        this.yMouseScreen = evt.getY();
        if (this.yMouseScreen >= this.getHeight()) {
            this.yMouseScreen = this.getHeight() - 1;
        } else if (this.yMouseScreen < 0) {
            this.yMouseScreen = 0;
        }
        LemmCursor.setX(Core.unscale(this.xMouseScreen));
        LemmCursor.setY(Core.unscale(this.yMouseScreen));
        if (this.isFocused) {
            this.mouseHasEntered = true;
        }
        switch (GameController.getGameState()) {
            case INTRO: 
            case BRIEFING: 
            case DEBRIEFING: {
                TextScreen.getDialog().handleMouseMove(Core.unscale(this.xMouseScreen) - Core.getDrawWidth() / 2, Core.unscale(this.yMouseScreen) - Core.getDrawHeight() / 2);
            }
            case LEVEL: {
                this.mouseDx = this.xMouse - oldX;
                this.mouseDy = this.yMouse - oldY;
                this.mouseDragStartX = Core.unscale(evt.getX());
                this.mouseDragStartY = Core.unscale(evt.getY());
                evt.consume();
                break;
            }
        }
    }

    private void formMouseWheelMoved(MouseWheelEvent evt) {
        block2: {
            int wheelRotation;
            block3: {
                if (GameController.getGameState() != GameController.State.LEVEL || GameController.isOptionEnabled(GameController.SLTooOption.DISABLE_SCROLL_WHEEL)) break block2;
                wheelRotation = evt.getWheelRotation();
                if (wheelRotation <= 0) break block3;
                int i = 0;
                while (i < wheelRotation) {
                    GameController.nextSkill();
                    ++i;
                }
                break block2;
            }
            if (wheelRotation >= 0) break block2;
            int i = 0;
            while (i > wheelRotation) {
                GameController.previousSkill();
                --i;
            }
        }
    }

    private static LemmImage setFullyOpaque(LemmImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int pixel = img.getRGB(x, y);
                int alpha = pixel >> 24 & 0xFF;
                if (alpha < 255) {
                    img.setRGB(x, y, -16777216);
                }
                ++x;
            }
            ++y;
        }
        return img;
    }

    public void setCursor(LemmCursor.CursorType c) {
        LemmCursor.setType(c);
        super.setCursor(LemmCursor.getCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Object object = this.paintSemaphore;
        synchronized (object) {
            if (this.offBuffer != null) {
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, Core.isBilinear() ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                g2.drawImage(this.offBuffer.getImage().getImage(), 0, 0, Core.getScaledDrawWidth(), Core.getScaledDrawHeight(), null);
            }
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    void focusLost() {
        this.shiftPressed = false;
        this.controlPressed = false;
        this.leftPressed = false;
        this.rightPressed = false;
        this.upPressed = false;
        this.downPressed = false;
        GameController.releasePlus(3);
        GameController.releaseMinus(3);
        GameController.releaseIcon(Icons.IconType.MINUS);
        GameController.releaseIcon(Icons.IconType.PLUS);
        GameController.releaseIcon(Icons.IconType.NUKE);
        GameController.releaseIcon(Icons.IconType.RESTART);
        LemmCursor.setBox(false);
        this.setCursor(LemmCursor.CursorType.NORMAL);
        this.isFocused = false;
        this.mouseHasEntered = false;
        this.holdingMinimap = false;
    }

    void focusGained() {
        this.isFocused = true;
    }

    private int getPadding() {
        int maxLemmings = GameController.getNumLemmingsMax();
        int numDigits = String.valueOf(maxLemmings).length();
        switch (numDigits) {
            case 1: {
                return 40;
            }
            case 2: {
                return 30;
            }
            case 3: {
                return 20;
            }
        }
        return 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redraw() {
        if (this.offBuffer == null) {
            return;
        }
        Object object = this.paintSemaphore;
        synchronized (object) {
            GraphicsContext offGfx = this.offBuffer.getGraphicsContext();
            switch (GameController.getGameState()) {
                case INTRO: 
                case BRIEFING: 
                case DEBRIEFING: {
                    offGfx.setClip(0, 0, Core.getDrawWidth(), Core.getDrawHeight());
                    TextScreen.drawScreen(offGfx, 0, 0, Core.getDrawWidth(), Core.getDrawHeight());
                    break;
                }
                case LEVEL: 
                case LEVEL_END: {
                    LemmImage replayImage;
                    LemmImage fgImage = GameController.getFgImage();
                    if (fgImage == null) break;
                    int xOfsTemp = GameController.getXPos();
                    int minimapXOfsTemp = Minimap.getXPos();
                    int yOfsTemp = GameController.getYPos();
                    int width = Core.getDrawWidth();
                    int height = Core.getDrawHeight();
                    int levelHeight = Math.min(320, height);
                    Level level = GameController.getLevel();
                    if (level != null) {
                        offGfx.setClip(0, 0, width, levelHeight);
                        offGfx.setBackground(level.getBgColor());
                        offGfx.clearRect(0, 0, width, levelHeight);
                        GameController.getLevel().drawBackground(offGfx, width, levelHeight, xOfsTemp, yOfsTemp);
                        GameController.getLevel().drawBehindObjects(offGfx, width, height, xOfsTemp, yOfsTemp);
                        offGfx.drawImage(fgImage, 0, 0, width, levelHeight, xOfsTemp, yOfsTemp, xOfsTemp + width, yOfsTemp + levelHeight);
                        GameController.getLevel().drawInFrontObjects(offGfx, width, height, xOfsTemp, yOfsTemp);
                    }
                    offGfx.setClip(0, 320, width, height - 320);
                    offGfx.setBackground(Color.BLACK);
                    offGfx.clearRect(0, 320, width, height - 320);
                    int iconBarX = this.menuOffsetX + this.getIconBarX();
                    int iconBarY = this.getIconBarY();
                    int countBarX = this.menuOffsetX + this.getIconBarX();
                    int countBarY = 360;
                    if (GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR)) {
                        countBarY += 7;
                    } else if (!GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR) && GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_STATUS)) {
                        iconBarY += 3;
                        countBarY += 3;
                    }
                    GameController.drawIconsAndCounters(offGfx, iconBarX, iconBarY, countBarX, countBarY);
                    int XOffset = 0;
                    int YOffset = 0;
                    if (GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR)) {
                        XOffset = this.needVLockIcon() ? 17 : 29;
                    } else {
                        XOffset = this.needVLockIcon() ? -1 : 37;
                        YOffset = 6;
                    }
                    if (XOffset > 0) {
                        LemmImage filler = MiscGfx.getImage(MiscGfx.Index.ICONBAR_FILLER);
                        filler = LemminiPanel.setFullyOpaque(filler);
                        offGfx.drawImage(filler, this.menuOffsetX + 528 - XOffset, this.getIconBarY() - YOffset);
                        filler = null;
                    }
                    if (GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR)) {
                        this.drawMiniMapLarge(offGfx, width, height, minimapXOfsTemp, yOfsTemp);
                    } else {
                        this.drawMiniMap(offGfx, width, height, minimapXOfsTemp, yOfsTemp);
                    }
                    offGfx.setClip(0, 0, width, levelHeight);
                    GameController.drawLemmings(offGfx);
                    Lemming lemmUnderCursor = GameController.lemmUnderCursor(LemmCursor.getType());
                    offGfx.setClip(0, 0, width, levelHeight);
                    GameController.drawExplosions(offGfx, width, 320, xOfsTemp, yOfsTemp);
                    offGfx.setClip(0, 0, width, height);
                    GameController.drawVisualSfx(offGfx);
                    LemmImage outStrImg = this.outStrBuffer.getImage();
                    GraphicsContext outStrGfx = this.outStrBuffer.getGraphicsContext();
                    outStrGfx.clearRect(0, 0, outStrImg.getWidth(), outStrImg.getHeight());
                    int statusBarGap = 8;
                    if (GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_STATUS)) {
                        statusBarGap = 18;
                    }
                    int yOffset = 320 + statusBarGap;
                    if (Core.player.isDebugMode() && this.showDebugCursorInfo) {
                        Stencil stencil = GameController.getStencil();
                        if (stencil != null) {
                            int stencilVal = stencil.getMask(this.xMouse, this.yMouse);
                            int stencilObject = stencil.getMaskObjectID(this.xMouse, this.yMouse);
                            String strObj = stencilObject >= 0 ? ", Obj: " + stencilObject : "";
                            String test = String.format("X: %4d, Y: %3d, Mask: %4d%s", this.xMouse, this.yMouse, stencilVal, strObj);
                            LemmFont.strImage(outStrGfx, test);
                            offGfx.drawImage(outStrImg, this.menuOffsetX + 4, yOffset);
                        }
                    } else {
                        String strHome;
                        String lemmingInfo;
                        if (lemmUnderCursor != null) {
                            lemmingInfo = lemmUnderCursor.getLemmingInfo();
                            int num = GameController.getNumLemmsUnderCursor();
                            if (num > 1) {
                                lemmingInfo = String.valueOf(lemmingInfo) + " " + num;
                            }
                        } else {
                            lemmingInfo = "";
                        }
                        if (GameController.isOptionEnabled(GameController.Option.NO_PERCENTAGES) || GameController.getNumLemmingsMax() > 100) {
                            strHome = Integer.toString(GameController.getNumExited());
                        } else {
                            int max = GameController.getNumLemmingsMax();
                            int home = GameController.getNumExited() * 100 / max;
                            strHome = String.format("%02d%%", home);
                        }
                        if (!GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_STATUS)) {
                            String status = String.format("%-15s OUT %-4d IN %-4s TIME %s", lemmingInfo, GameController.getNumLemmings(), strHome, GameController.getTimeString());
                            LemmFont.strImage(outStrGfx, status);
                            offGfx.drawImage(outStrImg, this.menuOffsetX + 4, yOffset);
                        } else {
                            LemmFont.LemmColor timeColor;
                            int hatchLems = GameController.getNumLemmingsUnreleased();
                            int maxLevelLemm = GameController.getNumLemmingsMax();
                            int active = GameController.getNumLemmings();
                            int saveRequirement = GameController.getNumToRescue();
                            int exited = GameController.getNumExited();
                            int maxPossibleLemm = GameController.getNumLemmingsPossibleMax();
                            int homeSubValue = GameController.isOptionEnabled(GameController.Option.NO_PERCENTAGES) ? saveRequirement : maxLevelLemm;
                            int charWidthLa = 18;
                            int charWidthSm = 9;
                            int iconWidth = 32;
                            int padding = this.getPadding();
                            int xSpace = 4;
                            int xLemInfo = 4;
                            int xTime = 638;
                            int xHome = xTime - (String.valueOf(homeSubValue).length() + 1) * charWidthSm - strHome.length() * charWidthLa - xSpace - iconWidth - padding;
                            int xActive = xHome - (String.valueOf(maxLevelLemm).length() + 1) * charWidthSm - String.valueOf(active).length() * charWidthLa - xSpace - iconWidth - padding;
                            int xHatch = xActive - (String.valueOf(maxPossibleLemm).length() + 1) * charWidthSm - String.valueOf(hatchLems).length() * charWidthLa - xSpace - iconWidth - padding;
                            LemmImage lemmInfo = LemmFont.strImage(String.format("%-15s", lemmingInfo));
                            offGfx.drawImage(lemmInfo, this.menuOffsetX + xLemInfo, yOffset);
                            LemmImage lemmIconHatch = MiscGfx.getImage(MiscGfx.Index.STATUS_HATCH);
                            offGfx.drawImage(lemmIconHatch, this.menuOffsetX + xHatch, yOffset);
                            int xHatchW = lemmIconHatch.getWidth() + xSpace;
                            LemmImage lemmHatch = LemmFont.strImage(String.format("%d", hatchLems), LemmFont.LemmColor.GREEN);
                            offGfx.drawImage(lemmHatch, this.menuOffsetX + xHatch + xHatchW, yOffset);
                            int xMaxLevelLemm = xHatch + xHatchW + lemmHatch.getWidth();
                            LemmImage lemmLevelMax = LemmFont.strImage("/" + String.format("%d", maxLevelLemm), LemmFont.LemmColor.GREEN);
                            offGfx.drawImage(lemmLevelMax, this.menuOffsetX + xMaxLevelLemm, yOffset + 12, 0.5);
                            LemmImage lemmIconActive = MiscGfx.getImage(MiscGfx.Index.STATUS_ACTIVE);
                            offGfx.drawImage(lemmIconActive, this.menuOffsetX + xActive, yOffset);
                            int xActiveW = lemmIconActive.getWidth() + xSpace;
                            LemmFont.LemmColor activeLemColor = maxPossibleLemm < saveRequirement ? LemmFont.LemmColor.RED : LemmFont.LemmColor.GREEN;
                            LemmImage lemmActive = LemmFont.strImage(String.format("%d", active), activeLemColor);
                            offGfx.drawImage(lemmActive, this.menuOffsetX + xActive + xActiveW, yOffset);
                            int xMaxPossibleLemm = xActive + xActiveW + lemmActive.getWidth();
                            LemmImage lemmPossibleMax = LemmFont.strImage("/" + String.format("%d", maxPossibleLemm), activeLemColor);
                            offGfx.drawImage(lemmPossibleMax, this.menuOffsetX + xMaxPossibleLemm, yOffset + 12, 0.5);
                            LemmImage lemmIconHome = MiscGfx.getImage(MiscGfx.Index.STATUS_HOME);
                            offGfx.drawImage(lemmIconHome, this.menuOffsetX + xHome, yOffset);
                            int xHomeW = lemmIconHome.getWidth() + xSpace;
                            LemmImage lemmHome = saveRequirement > exited ? LemmFont.strImage(strHome, LemmFont.LemmColor.RED) : LemmFont.strImage(strHome);
                            offGfx.drawImage(lemmHome, this.menuOffsetX + xHome + xHomeW, yOffset);
                            int xhomeSubValue = xHome + xHomeW + lemmHome.getWidth();
                            LemmImage lemmHomeSubValue = LemmFont.strImage("/" + String.format("%d", homeSubValue), LemmFont.LemmColor.GREEN);
                            offGfx.drawImage(lemmHomeSubValue, this.menuOffsetX + xhomeSubValue, yOffset + 12, 0.5);
                            LemmImage lemmIconTime = MiscGfx.getImage(MiscGfx.Index.STATUS_TIME);
                            offGfx.drawImage(lemmIconTime, this.menuOffsetX + xTime, yOffset);
                            int xTimeW = lemmIconTime.getWidth() + xSpace;
                            int time = GameController.getTime();
                            String timeString = GameController.getTimeString();
                            if (GameController.isTimed()) {
                                timeColor = LemmFont.LemmColor.GREEN;
                                if (time <= 59) {
                                    timeColor = LemmFont.LemmColor.YELLOW;
                                }
                                if (time <= 10) {
                                    timeColor = LemmFont.LemmColor.RED;
                                }
                            } else {
                                timeColor = LemmFont.LemmColor.BLUE;
                            }
                            LemmImage lemmTime = LemmFont.strImage(String.format("%s", timeString), timeColor);
                            offGfx.drawImage(lemmTime, this.menuOffsetX + xTime + xTimeW, yOffset);
                            lemmIconHatch = null;
                            lemmIconActive = null;
                            lemmIconHome = null;
                            lemmIconTime = null;
                            lemmInfo = null;
                            lemmHatch = null;
                            lemmActive = null;
                            lemmHome = null;
                            lemmTime = null;
                        }
                    }
                    int debugModeOffset = 0;
                    int maxExitOffset = 0;
                    int charWidth = 9;
                    if (Core.player.isDebugMode()) {
                        String debugModeString = "DEBUG ";
                        debugModeOffset += 6 * charWidth;
                        if (this.draw) {
                            debugModeString = String.valueOf(debugModeString) + "DRAW ";
                            debugModeOffset += 5 * charWidth;
                        }
                        if (GameController.isSuperLemming()) {
                            debugModeString = String.valueOf(debugModeString) + "SUPERLEMMING ";
                            debugModeOffset += 13 * charWidth;
                        }
                        LemmImage modeImage = LemmFont.strImage(String.format("%s", debugModeString), LemmFont.LemmColor.BLUE);
                        offGfx.drawImage(modeImage, this.menuOffsetX + 4, 322, 0.5);
                    }
                    if (Core.player.isMaximumExitPhysics()) {
                        String maxExitString = "MAX-EXIT ";
                        maxExitOffset += 9 * charWidth;
                        LemmImage maxExitImage = LemmFont.strImage(String.format("%s", maxExitString), LemmFont.LemmColor.VIOLET);
                        offGfx.drawImage(maxExitImage, this.menuOffsetX + 4 + debugModeOffset, 322, 0.5);
                    }
                    if (GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_STATUS) && GameController.isOptionEnabled(GameController.SLTooOption.SHOW_LEVEL_NAME)) {
                        String rating = GameController.getCurLevelPack().getRatings().get(GameController.getCurRating());
                        int levelNum = GameController.getCurLevelNumber() + 1;
                        String levelName = String.valueOf(rating) + " " + levelNum + ": " + level.getLevelName().trim();
                        LemmImage lemmLevelName = LemmFont.strImage(levelName, LemmFont.LemmColor.GREEN);
                        offGfx.drawImage(lemmLevelName, this.menuOffsetX + 4 + debugModeOffset + maxExitOffset, 322, 0.5);
                        lemmLevelName = null;
                    }
                    if ((replayImage = GameController.getReplayImage()) != null) {
                        offGfx.drawImage(replayImage, width - 2 * replayImage.getWidth(), replayImage.getHeight());
                    }
                    if (lemmUnderCursor != null) {
                        if (GameController.isOptionEnabled(GameController.Option.CLASSIC_CURSOR)) {
                            if (!this.mouseHasEntered || LemmCursor.isBox()) break;
                            LemmCursor.setBox(true);
                            this.setCursor(LemmCursor.getCursor());
                            break;
                        }
                        int lx = lemmUnderCursor.footX() - xOfsTemp;
                        int ly = lemmUnderCursor.midY() - yOfsTemp;
                        LemmImage cursorImg = LemmCursor.getBoxImage();
                        offGfx.drawImage(cursorImg, lx -= cursorImg.getWidth() / 2, ly -= cursorImg.getHeight() / 2);
                        break;
                    }
                    if (!GameController.isOptionEnabled(GameController.Option.CLASSIC_CURSOR) || !LemmCursor.isBox()) break;
                    LemmCursor.setBox(false);
                    this.setCursor(LemmCursor.getCursor());
                    break;
                }
            }
            Fader.apply(offGfx);
            this.repaint();
        }
    }

    private void drawMiniMap(GraphicsContext offGfx, int width, int height, int minimapXOfsTemp, int yOfsTemp) {
        int BORDER_WIDTH = 4;
        offGfx.drawImage(MiscGfx.getMinimapImage(), this.menuOffsetX + this.getSmallX() - 4, this.getSmallY() - 4);
        offGfx.setClip(this.menuOffsetX + this.getSmallX(), this.getSmallY(), Minimap.getVisibleWidth(), Minimap.getVisibleHeight());
        Minimap.draw(offGfx, this.menuOffsetX + this.getSmallX(), this.getSmallY());
        GameController.drawMinimapLemmings(offGfx, this.menuOffsetX + this.getSmallX(), this.getSmallY());
        offGfx.setClip(0, 0, width, height);
        Minimap.drawFrame(offGfx, this.menuOffsetX + this.getSmallX(), this.getSmallY());
        if (minimapXOfsTemp > 0) {
            LemmImage leftArrow = MiscGfx.getImage(MiscGfx.Index.MINIMAP_ARROW_LEFT);
            offGfx.drawImage(leftArrow, this.menuOffsetX + this.getSmallX() - 4 - leftArrow.getWidth(), this.getSmallY() + Minimap.getVisibleHeight() / 2 - leftArrow.getHeight() / 2);
        }
        if (minimapXOfsTemp < ToolBox.scale(GameController.getWidth(), Minimap.getScaleX()) - Minimap.getVisibleWidth()) {
            LemmImage rightArrow = MiscGfx.getImage(MiscGfx.Index.MINIMAP_ARROW_RIGHT);
            offGfx.drawImage(rightArrow, this.menuOffsetX + this.getSmallX() + Minimap.getVisibleWidth() + 4, this.getSmallY() + Minimap.getVisibleHeight() / 2 - rightArrow.getHeight() / 2);
        }
        if (yOfsTemp > 0) {
            LemmImage upArrow = MiscGfx.getImage(MiscGfx.Index.MINIMAP_ARROW_UP);
            offGfx.drawImage(upArrow, this.menuOffsetX + this.getSmallX() + Minimap.getVisibleWidth() / 2 - upArrow.getWidth() / 2, this.getSmallY() - 4 - upArrow.getHeight());
        }
        if (yOfsTemp < GameController.getHeight() - 320) {
            LemmImage downArrow = MiscGfx.getImage(MiscGfx.Index.MINIMAP_ARROW_DOWN);
            offGfx.drawImage(downArrow, this.menuOffsetX + this.getSmallX() + Minimap.getVisibleWidth() / 2 - downArrow.getWidth() / 2, this.getSmallY() + Minimap.getVisibleHeight() + 4);
        }
    }

    private void drawMiniMapLarge(GraphicsContext offGfx, int width, int height, int minimapXOfsTemp, int yOfsTemp) {
        int BORDER_WIDTH = 7;
        offGfx.drawImage(MiscGfx.getMinimapLargeImage(), this.menuOffsetX + this.getSmallX() - 7, this.getSmallY() - 7);
        offGfx.setClip(this.menuOffsetX + this.getSmallX(), this.getSmallY(), Minimap.getVisibleWidth(), Minimap.getVisibleHeight());
        Minimap.draw(offGfx, this.menuOffsetX + this.getSmallX(), this.getSmallY());
        GameController.drawMinimapLemmings(offGfx, this.menuOffsetX + this.getSmallX(), this.getSmallY());
        offGfx.setClip(0, 0, width, height);
        Minimap.drawFrame(offGfx, this.menuOffsetX + this.getSmallX(), this.getSmallY());
        if (minimapXOfsTemp > 0) {
            LemmImage leftArrow = MiscGfx.getImage(MiscGfx.Index.MINIMAP_ARROW_LEFT);
            offGfx.drawImage(leftArrow, this.menuOffsetX + this.getSmallX() - 7 - leftArrow.getWidth(), this.getSmallY() + Minimap.getVisibleHeight() / 2 - leftArrow.getHeight() / 2);
        }
        if (minimapXOfsTemp < ToolBox.scale(GameController.getWidth(), Minimap.getScaleX()) - Minimap.getVisibleWidth()) {
            LemmImage rightArrow = MiscGfx.getImage(MiscGfx.Index.MINIMAP_ARROW_RIGHT);
            offGfx.drawImage(rightArrow, this.menuOffsetX + this.getSmallX() + Minimap.getVisibleWidth() + 7, this.getSmallY() + Minimap.getVisibleHeight() / 2 - rightArrow.getHeight() / 2);
        }
        if (yOfsTemp > 0) {
            LemmImage upArrow = MiscGfx.getImage(MiscGfx.Index.MINIMAP_ARROW_UP);
            offGfx.drawImage(upArrow, this.menuOffsetX + this.getSmallX() + Minimap.getVisibleWidth() / 2 - upArrow.getWidth() / 2, this.getSmallY() - 7 - upArrow.getHeight());
        }
        if (yOfsTemp < GameController.getHeight() - 320) {
            LemmImage downArrow = MiscGfx.getImage(MiscGfx.Index.MINIMAP_ARROW_DOWN);
            offGfx.drawImage(downArrow, this.menuOffsetX + this.getSmallX() + Minimap.getVisibleWidth() / 2 - downArrow.getWidth() / 2, this.getSmallY() + Minimap.getVisibleHeight() + 7);
        }
    }

    private void updateFrame() {
        LemmImage fgImage = GameController.getFgImage();
        switch (GameController.getGameState()) {
            case INTRO: {
                TextScreen.setMode(TextScreen.Mode.INTRO);
                TextScreen.update();
                TextScreen.getDialog().handleMouseMove(Core.unscale(this.xMouseScreen) - Core.getDrawWidth() / 2, Core.unscale(this.yMouseScreen) - Core.getDrawHeight() / 2);
                break;
            }
            case BRIEFING: {
                TextScreen.setMode(TextScreen.Mode.BRIEFING);
                TextScreen.update();
                TextScreen.getDialog().handleMouseMove(Core.unscale(this.xMouseScreen) - Core.getDrawWidth() / 2, Core.unscale(this.yMouseScreen) - Core.getDrawHeight() / 2);
                this.replaySaved = false;
                break;
            }
            case DEBRIEFING: {
                TextScreen.setMode(TextScreen.Mode.DEBRIEFING);
                TextScreen.update();
                TextScreen.getDialog().handleMouseMove(Core.unscale(this.xMouseScreen) - Core.getDrawWidth() / 2, Core.unscale(this.yMouseScreen) - Core.getDrawHeight() / 2);
                this.maybeAutoSaveReplay();
                break;
            }
            case LEVEL: 
            case LEVEL_END: {
                if (fgImage == null) break;
                GameController.update();
                int xOfsTemp = GameController.getXPos();
                int minimapXOfsTemp = Minimap.getXPos();
                int yOfsTemp = GameController.getYPos();
                if (this.holdingMinimap) {
                    int framePos = ToolBox.scale(xOfsTemp, Minimap.getScaleX()) - minimapXOfsTemp;
                    if (this.xMouseScreen < Core.scale(this.menuOffsetX + this.getSmallX()) && framePos <= 0) {
                        GameController.setXPos(xOfsTemp -= this.getStepSize());
                    } else if (this.xMouseScreen >= Core.scale(this.menuOffsetX + this.getSmallX() + Minimap.getVisibleWidth()) && framePos >= Minimap.getVisibleWidth() - ToolBox.scale(Core.getDrawWidth(), Minimap.getScaleX())) {
                        GameController.setXPos(xOfsTemp += this.getStepSize());
                    } else {
                        xOfsTemp = Minimap.move(Core.unscale(this.xMouseScreen) - this.getSmallX() - this.menuOffsetX, Core.unscale(this.yMouse) - this.getSmallY());
                        GameController.setXPos(xOfsTemp);
                    }
                    if (!GameController.isVerticalLock()) {
                        if (this.yMouseScreen < Core.scale(this.getSmallY())) {
                            GameController.setYPos(yOfsTemp -= this.getStepSize());
                        } else if (this.yMouseScreen >= Core.scale(this.getSmallY() + Minimap.getVisibleHeight())) {
                            GameController.setYPos(yOfsTemp += this.getStepSize());
                        }
                    }
                } else if (this.mouseHasEntered) {
                    int afterXPos;
                    int beforeXPos;
                    if (this.xMouseScreen >= this.getWidth() - Core.scale(20)) {
                        beforeXPos = GameController.getXPos();
                        GameController.setXPos(xOfsTemp += this.getStepSize());
                        afterXPos = GameController.getXPos();
                        this.xMouse += afterXPos - beforeXPos;
                    } else if (this.xMouseScreen < Core.scale(20)) {
                        beforeXPos = GameController.getXPos();
                        GameController.setXPos(xOfsTemp -= this.getStepSize());
                        afterXPos = GameController.getXPos();
                        this.xMouse -= beforeXPos - afterXPos;
                    }
                    if (!GameController.isVerticalLock()) {
                        int afterYPos;
                        int beforeYPos;
                        if (this.yMouseScreen >= this.getHeight() - Core.scale(20)) {
                            beforeYPos = GameController.getYPos();
                            GameController.setYPos(yOfsTemp += this.getStepSize());
                            afterYPos = GameController.getYPos();
                            this.yMouse += afterYPos - beforeYPos;
                        } else if (this.yMouseScreen < Core.scale(20)) {
                            beforeYPos = GameController.getYPos();
                            GameController.setYPos(yOfsTemp -= this.getStepSize());
                            afterYPos = GameController.getYPos();
                            this.yMouse -= beforeYPos - afterYPos;
                        }
                    }
                }
                if (this.rightPressed && !this.leftPressed) {
                    GameController.setXPos(xOfsTemp += this.getStepSize());
                } else if (this.leftPressed && !this.rightPressed) {
                    GameController.setXPos(xOfsTemp -= this.getStepSize());
                }
                if (!GameController.isVerticalLock()) {
                    if (this.downPressed && !this.upPressed) {
                        GameController.setYPos(yOfsTemp += this.getStepSize());
                    } else if (this.upPressed && !this.downPressed) {
                        GameController.setYPos(yOfsTemp -= this.getStepSize());
                    }
                }
                Minimap.adjustXPos();
                GameController.updateLemmsUnderCursor();
                break;
            }
        }
        GameController.fade();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block14: {
            Thread.currentThread().setPriority(6);
            thisPanel = this;
            repaintScheduler = Executors.newSingleThreadScheduledExecutor();
            repaintTask = (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, drawNextFrame(), ()V)((LemminiPanel)thisPanel);
            try {
                this.drawNextFrame = false;
                repaintScheduler.scheduleAtFixedRate(repaintTask, 0L, 30000000L, TimeUnit.NANOSECONDS);
lbl12:
                // 2 sources

                while (true) {
                    block15: {
                        var5_4 = this;
                        synchronized (var5_4) {
                            while (true) {
                                if (this.drawNextFrame) {
                                    break;
                                }
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException var6_6) {
                                    // empty catch block
                                }
                            }
                        }
                        if (!this.drawNextFrame) continue;
                        this.drawNextFrame = false;
                        gameState = GameController.getGameState();
                        if (gameState != GameController.State.LEVEL) break block14;
                        if (!GameController.isFastForward()) break block15;
                        multiplier = GameController.isTurbo() != false ? 9 : (GameController.isOptionEnabled(GameController.Option.FASTER_FAST_FORWARD) != false ? 6 : 3);
                        f = 1;
                        if (true) ** GOTO lbl51
                    }
                    if (GameController.isSuperLemming()) {
                        f = 1;
                        while (f < 3) {
                            GameController.update();
                            ++f;
                        }
                    }
                    break block14;
                    break;
                }
            }
            catch (Throwable ex) {
                ToolBox.showException(ex);
                System.exit(1);
                return;
            }
            do {
                GameController.update();
                ++f;
lbl51:
                // 2 sources

            } while (f < multiplier);
        }
        this.updateFrame();
        this.redraw();
        ** while (true)
    }

    public synchronized void drawNextFrame() {
        this.drawNextFrame = true;
        this.notifyAll();
    }

    private void debugDraw(int x, int y, boolean doDraw) {
        if (this.draw && Core.player.isDebugMode()) {
            int minimapVal;
            boolean classicSteel = GameController.getLevel().getClassicSteel();
            int rgbVal = doDraw ? -1 : 0;
            int n = minimapVal = doDraw || Minimap.isTinted() ? rgbVal : GameController.getLevel().getBgColor().getRGB();
            if (doDraw && Minimap.isTinted()) {
                minimapVal = Minimap.tintColor(minimapVal);
            }
            int xOfs = GameController.getXPos();
            int yOfs = GameController.getYPos();
            LemmImage fgImage = GameController.getFgImage();
            LemmImage fgImageSmall = Minimap.getImage();
            Stencil stencil = GameController.getStencil();
            double scaleX = (double)fgImageSmall.getWidth() / (double)fgImage.getWidth();
            double scaleY = (double)fgImageSmall.getHeight() / (double)fgImage.getHeight();
            double scaleXHalf = scaleX / 2.0;
            double scaleYHalf = scaleY / 2.0;
            if (this.drawBrushSize <= 0 || this.drawBrushSize >= 11) {
                this.drawBrushSize = 5;
            }
            int radius = this.drawBrushSize;
            int ya = y - radius;
            while (ya <= y + radius) {
                int xa = x - radius;
                while (xa <= x + radius) {
                    if (Math.pow(xa - x, 2.0) + Math.pow(ya - y, 2.0) <= Math.pow(radius, 2.0)) {
                        boolean drawSmallX;
                        double scaledY = ((double)ya + 0.5) * scaleY % 1.0;
                        boolean drawSmallY = scaledY >= (0.5 - scaleYHalf) % 1.0 && scaledY < (0.5 + scaleYHalf) % 1.0 || Math.abs(scaleY) >= 1.0;
                        double scaledX = ((double)xa + 0.5) * scaleX % 1.0;
                        boolean bl = drawSmallX = scaledX >= (0.5 - scaleXHalf) % 1.0 && scaledX < (0.5 + scaleXHalf) % 1.0 || Math.abs(scaleX) >= 1.0;
                        if (xa + xOfs >= 0 && xa + xOfs < GameController.getWidth() && ya + yOfs >= 0 && ya + yOfs < GameController.getHeight()) {
                            int[] objects;
                            int[] nArray = objects = stencil.getIDs(xa + xOfs, ya + yOfs);
                            int n2 = objects.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                int obj = nArray[n3];
                                SpriteObject spr = GameController.getLevel().getSprObject(obj);
                                if (spr != null && spr.getVisOnTerrain()) {
                                    if (doDraw) {
                                        if (!(!GameController.getLevel().getClassicSteel() && spr.getType().isOneWay() || spr.getType().isOneWay() && BooleanUtils.toBoolean((int)(stencil.getMask(xa + xOfs, ya + yOfs) & 0x10)))) {
                                            spr.setPixelVisibility(xa + xOfs - spr.getX(), ya + yOfs - spr.getY(), true);
                                        }
                                    } else {
                                        spr.setPixelVisibility(xa + xOfs - spr.getX(), ya + yOfs - spr.getY(), false);
                                    }
                                }
                                ++n3;
                            }
                            if (doDraw) {
                                stencil.orMask(xa + xOfs, ya + yOfs, 1);
                            } else {
                                stencil.andMask(xa + xOfs, ya + yOfs, classicSteel ? -2 : -3080);
                            }
                            GameController.getFgImage().setRGB(xa + xOfs, ya + yOfs, rgbVal);
                            if (drawSmallX && drawSmallY) {
                                fgImageSmall.setRGB(ToolBox.scale(xa + xOfs, scaleX), ToolBox.scale(ya + yOfs, scaleY), minimapVal);
                            }
                        }
                    }
                    ++xa;
                }
                ++ya;
            }
        }
    }

    void handleChooseLevel() {
        LevelDialog ld = new LevelDialog((Frame)this.getParentFrame(), true);
        ld.setVisible(true);
        int[] level = ld.getSelectedLevel();
        if (level != null) {
            GameController.requestChangeLevel(level[0], level[1], level[2], false);
            this.getParentFrame().setRestartEnabled(true);
        }
    }

    void loadDefaultLevel() {
        String[] parts;
        int[] nArray = new int[3];
        nArray[0] = 1;
        int[] level = nArray;
        String savedLevel = Core.programProps.get("lastLevelPlayed", null);
        if (savedLevel != null && !savedLevel.isEmpty() && (parts = savedLevel.split(",")).length == 3) {
            try {
                int packIndex = Integer.parseInt(parts[0].trim());
                int ratingIndex = Integer.parseInt(parts[1].trim());
                int levelIndex = Integer.parseInt(parts[2].trim());
                if (this.isValidLevel(packIndex, ratingIndex, levelIndex)) {
                    LevelPack pack = GameController.getLevelPack(packIndex);
                    boolean unbeatenLevelFound = false;
                    if (!Core.player.getLevelRecord(pack.getName(), pack.getRatings().get(ratingIndex).toString(), levelIndex).isCompleted()) {
                        unbeatenLevelFound = true;
                    } else {
                        int r = 0;
                        while (r < pack.getRatings().size()) {
                            int l = 0;
                            while (l < pack.getLevelCount(r)) {
                                if (!Core.player.getLevelRecord(pack.getName(), pack.getRatings().get(r).toString(), l).isCompleted()) {
                                    ratingIndex = r;
                                    levelIndex = l;
                                    unbeatenLevelFound = true;
                                    break;
                                }
                                ++l;
                            }
                            if (unbeatenLevelFound) break;
                            ++r;
                        }
                        if (!unbeatenLevelFound) {
                            int p = 0;
                            while (p < GameController.getLevelPackCount()) {
                                LevelPack nextPack = GameController.getLevelPack(p);
                                int r2 = 0;
                                while (r2 < nextPack.getRatings().size()) {
                                    int l = 0;
                                    while (l < nextPack.getLevelCount(r2)) {
                                        if (!Core.player.getLevelRecord(nextPack.getName(), nextPack.getRatings().get(r2).toString(), l).isCompleted()) {
                                            packIndex = p;
                                            ratingIndex = r2;
                                            levelIndex = l;
                                            unbeatenLevelFound = true;
                                            break;
                                        }
                                        ++l;
                                    }
                                    if (unbeatenLevelFound) break;
                                    ++r2;
                                }
                                if (unbeatenLevelFound) break;
                                ++p;
                            }
                        }
                    }
                    if (unbeatenLevelFound) {
                        level[0] = packIndex;
                        level[1] = ratingIndex;
                        level[2] = levelIndex;
                    }
                }
            }
            catch (NumberFormatException e) {
                System.err.println("Error parsing lastLevelPlayed: " + savedLevel);
            }
        }
        try {
            GameController.requestChangeLevel(level[0], level[1], level[2], false);
            this.getParentFrame().setRestartEnabled(true);
        }
        catch (Exception e) {
            this.handleChooseLevel();
        }
    }

    private boolean isValidLevel(int packIndex, int ratingIndex, int levelIndex) {
        if (packIndex < 0 || packIndex >= GameController.getLevelPackCount()) {
            return false;
        }
        if (ratingIndex < 0 || ratingIndex >= GameController.getLevelPack(packIndex).getRatings().size()) {
            return false;
        }
        return levelIndex >= 0 && levelIndex < GameController.getLevelPack(packIndex).getLevels(ratingIndex).size();
    }

    void startLevel() {
        GameController.setTransition(GameController.TransitionState.TO_LEVEL);
        Fader.setState(Fader.State.OUT);
        GameController.resetGain();
    }

    void continueToNextLevel() {
        GameController.nextLevel();
        GameController.requestChangeLevel(GameController.getCurLevelPackIdx(), GameController.getCurRating(), GameController.getCurLevelNumber(), false);
    }

    public void findBestLevelToLoad() {
        if (GameController.wasLost()) {
            GameController.requestRestartLevel(false, true);
        } else {
            if (!GameController.nextLevel() && !GameController.nextRating()) {
                this.loadDefaultLevel();
                return;
            }
            GameController.requestChangeLevel(GameController.getCurLevelPackIdx(), GameController.getCurRating(), GameController.getCurLevelNumber(), false);
        }
    }

    void exitToMenu() {
        GameController.setTransition(GameController.TransitionState.TO_INTRO);
        Fader.setState(Fader.State.OUT);
        Core.setTitle("RetroLemmini");
    }

    private void maybeAutoSaveReplay() {
        if (!GameController.isOptionEnabled(GameController.RetroLemminiOption.AUTOSAVE_REPLAYS)) {
            return;
        }
        if (this.replaySaved) {
            return;
        }
        if (GameController.getWasCheated() || GameController.wasLost()) {
            return;
        }
        Level level = GameController.getLevel();
        LevelPack levelPack = GameController.getCurLevelPack();
        int curRating = GameController.getCurRating();
        int curLevelNum = GameController.getCurLevelNumber();
        if (level == null || levelPack == null) {
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH_mm_ss__dd_MM_yyyy");
        String timestamp = now.format(formatter);
        String levelName = level.getLevelName().replaceAll("[^a-zA-Z0-9_\\-]", "_");
        String levelPackName = levelPack.getName().replaceAll("[^a-zA-Z0-9_\\-]", "_");
        String ratingName = levelPack.getRatings().get(curRating).replaceAll("[^a-zA-Z0-9_\\-]", "_");
        String replayFileName = String.format("%s__%s__%02d__%s__%s." + Core.REPLAY_EXTENSIONS[0], levelPackName, ratingName, curLevelNum + 1, levelName, timestamp);
        Path replayPath = Core.resourcePath.resolve("replays/").resolve(replayFileName);
        System.out.println("replayPath = " + replayPath);
        if (!GameController.saveReplay(replayPath)) {
            JOptionPane.showMessageDialog(this.getParent(), "Unable to auto-save replay.", "Error", 0);
        } else {
            this.replaySaved = true;
        }
    }

    void handleSaveReplay() {
        Path replayPath = ToolBox.getFileName(this.getParent(), Core.resourcePath.resolve("replays/"), "Save Replay", false, false, Core.REPLAY_EXTENSIONS);
        if (replayPath != null) {
            try {
                String ext = FilenameUtils.getExtension(replayPath.getFileName().toString());
                if (ext == null || ext.isEmpty()) {
                    replayPath = replayPath.resolveSibling(String.valueOf(replayPath.getFileName().toString()) + "." + Core.REPLAY_EXTENSIONS[0]);
                }
                if (GameController.saveReplay(replayPath)) {
                    return;
                }
                JOptionPane.showMessageDialog(this.getParent(), "Unable to save replay.", "Error", 0);
            }
            catch (HeadlessException ex) {
                ToolBox.showException(ex);
            }
        }
    }

    private boolean checkForDMARemasters(String replayPackName, String actualPackName) {
        if (replayPackName.equals("DMA Lemmings [Remastered]")) {
            return ToolBox.looselyEquals(actualPackName, "Lemmings") || ToolBox.looselyEquals(actualPackName, "DMA Lemmings [Remastered]");
        }
        if (replayPackName.equals("DMA Oh No! More Lemmings [Remastered]")) {
            return ToolBox.looselyEquals(actualPackName, "Oh No! More Lemmings") || ToolBox.looselyEquals(actualPackName, "DMA Oh No! More Lemmings [Remastered]");
        }
        return false;
    }

    void handleLoadReplay() {
        Path replayPath = ToolBox.getFileName(this.getParent(), Core.resourcePath.resolve("replays/"), "Load Replay", true, false, Core.REPLAY_EXTENSIONS);
        if (replayPath != null) {
            try {
                ReplayLevelInfo rli;
                if (FilenameUtils.getExtension(replayPath.getFileName().toString()).equalsIgnoreCase("rpl") && (rli = GameController.loadReplay(replayPath)) != null) {
                    int lpn = -1;
                    int rn = -1;
                    int ln = -1;
                    LevelPack lp = null;
                    int i = 0;
                    while (i < GameController.getLevelPackCount()) {
                        LevelPack lpTemp = GameController.getLevelPack(i);
                        if (ToolBox.looselyEquals(lpTemp.getName(), rli.getLevelPack()) || this.checkForDMARemasters(rli.getLevelPack(), lpTemp.getName())) {
                            lpn = i;
                            lp = lpTemp;
                        }
                        ++i;
                    }
                    if (lpn < 0) {
                        lp = GameController.getLevelPack(0);
                        lpn = 0;
                    }
                    if (lp != null && lpn >= 0) {
                        List<String> ratings = lp.getRatings();
                        int rnTemp = rli.getRatingNumber();
                        if (rnTemp < ratings.size()) {
                            rn = rnTemp;
                        }
                        if (rn < 0 || ToolBox.looselyEquals(ratings.get(rn), rli.getRatingName())) {
                            int i2 = 0;
                            while (i2 < ratings.size()) {
                                if (ToolBox.looselyEquals(ratings.get(i2), rli.getRatingName())) {
                                    rn = i2;
                                }
                                ++i2;
                            }
                        }
                        if (rn < 0) {
                            rn = 0;
                        }
                        if (rn >= 0) {
                            List<String> levels = lp.getLevels(rn);
                            int lnTemp = rli.getLvlNumber();
                            if (lnTemp < levels.size()) {
                                ln = lnTemp;
                            }
                            if (ln < 0 || ToolBox.looselyEquals(levels.get(ln), rli.getLvlName())) {
                                int i3 = 0;
                                while (i3 < levels.size()) {
                                    if (ToolBox.looselyEquals(levels.get(i3), rli.getLvlName())) {
                                        ln = i3;
                                    }
                                    ++i3;
                                }
                            }
                        }
                    }
                    if (lpn >= 0 && rn >= 0 && ln >= 0) {
                        GameController.requestChangeLevel(lpn, rn, ln, true);
                        this.getParentFrame().setRestartEnabled(true);
                    } else {
                        JOptionPane.showMessageDialog(this.getParent(), "Level specified in replay file does not exist.", "Load Replay", 0);
                    }
                    return;
                }
                JOptionPane.showMessageDialog(this.getParent(), "Wrong format!", "Load Replay", 0);
            }
            catch (LemmException ex) {
                JOptionPane.showMessageDialog(this.getParent(), ex.getMessage(), "Load Replay", 0);
            }
            catch (Exception ex) {
                ToolBox.showException(ex);
            }
        }
    }

    void handleEnterCode() {
        LevelCodeDialog lcd = new LevelCodeDialog((Frame)this.getParentFrame(), true);
        lcd.setVisible(true);
        String levelCode = lcd.getCode();
        int lvlPack = lcd.getLevelPack();
        if (levelCode != null && !levelCode.isEmpty() && lvlPack > 0) {
            if ((levelCode = levelCode.trim()).toLowerCase().equals("0xlemdebug")) {
                JOptionPane.showMessageDialog(this.getParent(), "All Levels and Debug Mode activated.", "Cheater!", 1);
                Core.player.setDebugMode(true);
                return;
            }
            if (levelCode.toLowerCase().equals("exitrule0k") || levelCode.toLowerCase().equals("directdr0p")) {
                JOptionPane.showMessageDialog(this.getParent(), "Maximum Exit Physics activated.", "Geronimo!", 1);
                Core.player.setMaximumExitPhysics(true);
                return;
            }
            levelCode = levelCode.toUpperCase();
            LevelPack lpack = GameController.getLevelPack(lvlPack);
            int[] codeInfo = LevelCode.getLevel(lpack.getCodeSeed(), levelCode, lpack.getCodeOffset());
            if (codeInfo != null) {
                if (Core.player.isDebugMode()) {
                    JOptionPane.showMessageDialog(this.getParent(), String.format("Level: %d%nPercent Saved: %d%%%nTimes Failed: %d%nUnknown: %d", codeInfo[0] + 1, codeInfo[1], codeInfo[2], codeInfo[3]), "Code Info", 1);
                }
                int[] l = GameController.relLevelNum(lvlPack, codeInfo[0]);
                int rating = l[0];
                int lvlRel = l[1];
                if (rating >= 0 && lvlRel >= 0) {
                    Core.player.setAvailable(lpack.getName(), lpack.getRatings().get(rating), lvlRel);
                    GameController.requestChangeLevel(lvlPack, rating, lvlRel, false);
                    this.getParentFrame().setRestartEnabled(true);
                    return;
                }
            }
        }
        if (lvlPack != -1) {
            JOptionPane.showMessageDialog(this.getParent(), "Invalid Level Code.", "Error", 0);
        }
    }

    void handlePlayers() {
        Core.player.store();
        PlayerDialog d = new PlayerDialog((Frame)this.getParentFrame(), true);
        d.setVisible(true);
        List<String> players = d.getPlayers();
        if (players != null) {
            String player = Core.player.getName();
            int playerIdx = d.getSelection();
            if (playerIdx != -1) {
                player = players.get(playerIdx);
            }
            int i = 0;
            while (i < Core.getPlayerCount()) {
                String p = Core.getPlayer(i);
                if (!players.contains(p)) {
                    Core.deletePlayer(i);
                    if (p.equals(player)) {
                        player = "default";
                    }
                }
                ++i;
            }
            Core.clearPlayers();
            if (!players.contains("default")) {
                players.add("default");
            }
            players.stream().forEachOrdered(Core::addPlayer);
            if (!Core.player.getName().equals(player) && GameController.getGameState() != GameController.State.INTRO) {
                if (GameController.getGameState() == GameController.State.LEVEL) {
                    GameController.setGameState(GameController.State.LEVEL_END);
                }
                GameController.setTransition(GameController.TransitionState.TO_INTRO);
                Fader.setState(Fader.State.OUT);
                Core.setTitle("RetroLemmini");
            }
            Core.player = new Player(player);
        }
    }

    void handleOptions() {
        boolean oldMinimapOption = GameController.isOptionEnabled(GameController.RetroLemminiOption.FULL_COLOR_MINIMAP);
        boolean oldMenuBarVisOption = GameController.isOptionEnabled(GameController.RetroLemminiOption.SHOW_MENU_BAR);
        boolean oldScrollerOption = GameController.isOptionEnabled(GameController.SLTooOption.CLASSIC_SCROLLER);
        GameController.MenuThemeOption oldMenuThemeOption = GameController.getMenuThemeOption();
        OptionsDialog d = new OptionsDialog((Frame)this.getParentFrame(), true);
        d.setVisible(true);
        if (oldMinimapOption != GameController.isOptionEnabled(GameController.RetroLemminiOption.FULL_COLOR_MINIMAP) && GameController.getGameState() == GameController.State.LEVEL) {
            Minimap.init(0.0625, 0.125, oldMinimapOption);
        }
        if (oldMenuBarVisOption != GameController.isOptionEnabled(GameController.RetroLemminiOption.SHOW_MENU_BAR)) {
            this.getParentFrame().toggleMenuBarVisibility();
        }
        if (oldScrollerOption != GameController.isOptionEnabled(GameController.SLTooOption.CLASSIC_SCROLLER)) {
            TextScreen.toggleScrollerType();
        }
        if (oldMenuThemeOption != GameController.getMenuThemeOption()) {
            TextScreen.setMenuTheme();
        }
        d.dispose();
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        LemminiFrame parentFrame = this.getParentFrame();
        int frameState = 0;
        if (parentFrame != null) {
            frameState = parentFrame.getExtendedState();
        }
        if (!BooleanUtils.toBoolean((int)(frameState & 2))) {
            this.unmaximizedWidth = width;
        }
        if (!BooleanUtils.toBoolean((int)(frameState & 4))) {
            this.unmaximizedHeight = height;
        }
        this.setScale(this.getWidth(), this.getHeight());
        Core.setDrawSize(Core.unscale(this.getWidth()), Core.unscale(this.getHeight()));
        this.setBufferSize(Core.getDrawWidth(), Core.getDrawHeight());
        GameController.setXPos(GameController.getXPos());
        GameController.setYPos(GameController.getYPos());
    }

    private void setScale(int width, int height) {
        Dimension minSize = this.getMinimumSize();
        if ((double)width / (double)height >= (double)minSize.width / (double)minSize.height) {
            Core.setScale((double)height / (double)minSize.height);
        } else {
            Core.setScale((double)width / (double)minSize.width);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBufferSize(int width, int height) {
        if (width <= 0 || height <= 0 || LemmFont.getHeight() <= 0) {
            return;
        }
        Object object = this.paintSemaphore;
        synchronized (object) {
            if (this.offBuffer == null) {
                this.offBuffer = new GraphicsBuffer(width, height, 1, true);
            } else {
                this.offBuffer.setSize(width, height);
            }
            if (this.outStrBuffer == null) {
                this.outStrBuffer = new GraphicsBuffer(width, LemmFont.getHeight(), 3, true);
            } else {
                this.outStrBuffer.setSize(width, LemmFont.getHeight());
            }
            this.menuOffsetX = Math.max(0, (width - this.getMinimumSize().width) / 2);
        }
    }

    private LemminiFrame getParentFrame() {
        Container container = this.getParent();
        while (container != null && !(container instanceof LemminiFrame)) {
            container = container.getParent();
        }
        return (LemminiFrame)container;
    }

    int getUnmaximizedWidth() {
        return this.unmaximizedWidth;
    }

    int getUnmaximizedHeight() {
        return this.unmaximizedHeight;
    }

    int getCursorX() {
        return this.xMouse;
    }

    int getCursorY() {
        return this.yMouse;
    }

    boolean isShiftPressed() {
        return this.shiftPressed;
    }

    void setShiftPressed(boolean p) {
        this.shiftPressed = p;
    }

    boolean isControlPressed() {
        return this.controlPressed;
    }

    void setControlPressed(boolean p) {
        this.controlPressed = p;
    }

    boolean isAltPressed() {
        return this.altPressed;
    }

    void setAltPressed(boolean p) {
        this.altPressed = p;
    }

    boolean isLeftPressed() {
        return this.leftPressed;
    }

    void setLeftPressed(boolean p) {
        this.leftPressed = p;
    }

    boolean isRightPressed() {
        return this.rightPressed;
    }

    void setRightPressed(boolean p) {
        this.rightPressed = p;
    }

    boolean isUpPressed() {
        return this.upPressed;
    }

    void setUpPressed(boolean p) {
        this.upPressed = p;
    }

    boolean isDownPressed() {
        return this.downPressed;
    }

    void setDownPressed(boolean p) {
        this.downPressed = p;
    }

    boolean getDebugDraw() {
        return this.draw;
    }

    void setDebugDraw(boolean d) {
        this.draw = d;
    }

    boolean debugCursorInfoVisible() {
        return this.showDebugCursorInfo;
    }

    void setDebugCursorInfo(boolean i) {
        this.showDebugCursorInfo = i;
    }

    private int getStepSize() {
        return this.shiftPressed ? 16 : 4;
    }

    public int getDrawBrushSize() {
        return this.drawBrushSize;
    }

    public void setDrawBrushSize(int drawBrushSize) {
        this.drawBrushSize = drawBrushSize;
    }
}

