/*
 * Decompiled with CFR 0.152.
 */
package lemmini;

import java.awt.Desktop;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.swing.GroupLayout;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import keyrepeatfix.RepeatingReleasedEventsFixer;
import lemmini.LemminiPanel;
import lemmini.game.Core;
import lemmini.game.GameController;
import lemmini.game.Icons;
import lemmini.game.LemmCursor;
import lemmini.game.LemmException;
import lemmini.game.Lemming;
import lemmini.game.LevelPack;
import lemmini.game.ResourceException;
import lemmini.game.Vsfx;
import lemmini.gameutil.Fader;
import lemmini.graphics.LemmImage;
import lemmini.sound.Music;
import lemmini.tools.ToolBox;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;

public class LemminiFrame
extends JFrame {
    public static final int LEVEL_HEIGHT = 320;
    private static final long serialVersionUID = 1L;
    private int unmaximizedPosX;
    private int unmaximizedPosY;
    private double userMusicVolume;
    private double userSoundVolume;
    static LemminiFrame thisFrame;
    private JMenuBar jMenuBarMain;
    private JMenu jMenuFile;
    private JMenuItem jMenuItemEnterLevelCode;
    private JMenuItem jMenuItemExit;
    private JMenuItem jMenuItemLoadReplay;
    private JMenuItem jMenuItemManagePlayers;
    private JMenuItem jMenuItemOptions;
    private JMenuItem jMenuItemHotkeys;
    private JMenuItem jMenuItemAbout;
    private JMenuItem jMenuItemChooseLevel;
    private JMenuItem jMenuItemRestartLevel;
    private JMenu jMenuLevel;
    private JMenu jMenuOptions;
    private JMenu jMenuPlayers;
    private LemminiPanel lemminiPanelMain;

    public LemminiFrame() {
        try {
            String currentFolderStr = URLDecoder.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile(), "UTF-8");
            System.out.println("Current directory: " + currentFolderStr);
            boolean successful = Core.init(currentFolderStr);
            if (!successful) {
                System.exit(0);
            }
        }
        catch (LemmException ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "Error", 0);
            System.exit(1);
        }
        catch (Throwable ex) {
            ToolBox.showException(ex);
            System.exit(1);
        }
        this.initComponents();
        this.setMinimumSize(this.getSize());
        RepeatingReleasedEventsFixer.install();
    }

    private static void consoleInit() {
        String logo = " ________  _______  _________  ________  ________  ___       _______   _____ ______   _____ ______   ___  ________   ___     \n|\\   __  \\|\\  ___ \\|\\___   ___\\\\   __  \\|\\   __  \\|\\  \\     |\\  ___ \\ |\\   _ \\  _   \\|\\   _ \\  _   \\|\\  \\|\\   ___  \\|\\  \\    \n\\ \\  \\|\\  \\ \\   __/\\|___ \\  \\_\\ \\  \\|\\  \\ \\  \\|\\  \\ \\  \\    \\ \\   __/|\\ \\  \\\\\\__\\ \\  \\ \\  \\\\\\__\\ \\  \\ \\  \\ \\  \\\\ \\  \\ \\  \\   \n \\ \\   _  _\\ \\  \\_|/__  \\ \\  \\ \\ \\   _  _\\ \\  \\\\\\  \\ \\  \\    \\ \\  \\_|/_\\ \\  \\\\|__| \\  \\ \\  \\\\|__| \\  \\ \\  \\ \\  \\\\ \\  \\ \\  \\  \n  \\ \\  \\\\  \\\\ \\  \\_|\\ \\  \\ \\  \\ \\ \\  \\\\  \\\\ \\  \\\\\\  \\ \\  \\____\\ \\  \\_|\\ \\ \\  \\    \\ \\  \\ \\  \\    \\ \\  \\ \\  \\ \\  \\\\ \\  \\ \\  \\ \n   \\ \\__\\\\ _\\\\ \\_______\\  \\ \\__\\ \\ \\__\\\\ _\\\\ \\_______\\ \\_______\\ \\_______\\ \\__\\    \\ \\__\\ \\__\\    \\ \\__\\ \\__\\ \\__\\\\ \\__\\ \\__\\\n    \\|__|\\|__|\\|_______|   \\|__|  \\|__|\\|__|\\|_______|\\|_______|\\|_______|\\|__|     \\|__|\\|__|     \\|__|\\|__|\\|__| \\|__|\\|__|\n";
        System.out.println(logo);
        System.out.println("===================================================================================================================");
        System.out.println("      Version 2.3      Commit " + LemminiFrame.getGitCommitSHA(7) + "      Date: " + "March 2025");
        System.out.println("===================================================================================================================");
        System.out.println("");
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy MMMM d  HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        System.out.println(String.valueOf(dtf.format(now)) + "\nloading RetroLemmini...");
        System.out.println("    Java version: " + System.getProperty("java.version").toString());
        System.out.println("    OS Name: " + System.getProperty("os.name"));
        System.out.println("    OS Version: " + System.getProperty("os.version"));
        System.out.println("");
    }

    void init() {
        System.out.println("\ninitializing LemminiFrame...");
        try {
            GameController.init();
            this.lemminiPanelMain.init();
            this.lemminiPanelMain.setCursor(LemmCursor.getCursor());
            this.toggleMenuBarVisibility();
            int w = Math.max(this.lemminiPanelMain.getWidth(), Core.programProps.getInt("frameWidth", this.lemminiPanelMain.getWidth()));
            int h = Math.max(this.lemminiPanelMain.getHeight(), Core.programProps.getInt("frameHeight", this.lemminiPanelMain.getHeight()));
            this.lemminiPanelMain.setSize(w, h);
            this.lemminiPanelMain.setPreferredSize(this.lemminiPanelMain.getSize());
            this.pack();
            this.setLocationRelativeTo(null);
            int posX = Core.programProps.getInt("framePosX", this.getX());
            int posY = Core.programProps.getInt("framePosY", this.getY());
            this.setLocation(posX, posY);
            int maximizedState = 0;
            if (Core.programProps.getBoolean("maximizedHoriz", false)) {
                maximizedState |= 2;
            }
            if (Core.programProps.getBoolean("maximizedVert", false)) {
                maximizedState |= 4;
            }
            this.setExtendedState(this.getExtendedState() | maximizedState);
            GameController.setGameState(GameController.State.INTRO);
            GameController.setTransition(GameController.TransitionState.NONE);
            Fader.setState(Fader.State.IN);
            Thread t = new Thread(this.lemminiPanelMain);
            t.start();
            this.setVisible(true);
        }
        catch (ResourceException ex) {
            Core.resourceError(ex.getMessage());
            return;
        }
        catch (Throwable ex) {
            ToolBox.showException(ex);
            System.exit(1);
        }
        System.out.println("LemminiFrame initialization complete.");
    }

    private void initComponents() {
        this.lemminiPanelMain = new LemminiPanel();
        this.jMenuBarMain = new JMenuBar();
        this.jMenuFile = new JMenu();
        this.jMenuItemExit = new JMenuItem();
        this.jMenuPlayers = new JMenu();
        this.jMenuItemManagePlayers = new JMenuItem();
        this.jMenuLevel = new JMenu();
        this.jMenuItemChooseLevel = new JMenuItem();
        this.jMenuItemRestartLevel = new JMenuItem();
        this.jMenuItemLoadReplay = new JMenuItem();
        this.jMenuItemEnterLevelCode = new JMenuItem();
        this.jMenuOptions = new JMenu();
        this.jMenuItemOptions = new JMenuItem();
        this.jMenuItemHotkeys = new JMenuItem();
        this.jMenuItemAbout = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("RetroLemmini");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(LemminiFrame.class.getClassLoader().getResource("icon_256.png")));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent evt) {
                LemminiFrame.this.formComponentMoved(evt);
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent evt) {
                LemminiFrame.this.formWindowGainedFocus(evt);
            }

            @Override
            public void windowLostFocus(WindowEvent evt) {
                LemminiFrame.this.formWindowLostFocus(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                LemminiFrame.this.formWindowClosed(evt);
            }

            @Override
            public void windowClosing(WindowEvent evt) {
                LemminiFrame.this.formWindowClosing(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LemminiFrame.this.formKeyPressed(evt);
            }

            @Override
            public void keyReleased(KeyEvent evt) {
                LemminiFrame.this.formKeyReleased(evt);
            }
        });
        GroupLayout lemminiPanelMainLayout = new GroupLayout(this.lemminiPanelMain);
        this.lemminiPanelMain.setLayout(lemminiPanelMainLayout);
        lemminiPanelMainLayout.setHorizontalGroup(lemminiPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 800, Short.MAX_VALUE));
        lemminiPanelMainLayout.setVerticalGroup(lemminiPanelMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 450, Short.MAX_VALUE));
        this.jMenuFile.setText("File");
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LemminiFrame.this.jMenuItemExitActionPerformed(evt);
            }
        });
        this.jMenuFile.add(this.jMenuItemExit);
        this.jMenuBarMain.add(this.jMenuFile);
        this.jMenuPlayers.setText("Players");
        this.jMenuItemManagePlayers.setText("Manage Players...");
        this.jMenuItemManagePlayers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LemminiFrame.this.jMenuItemManagePlayersActionPerformed(evt);
            }
        });
        this.jMenuPlayers.add(this.jMenuItemManagePlayers);
        this.jMenuBarMain.add(this.jMenuPlayers);
        this.jMenuLevel.setText("Level");
        this.jMenuItemChooseLevel.setText("Choose Level...");
        this.jMenuItemChooseLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LemminiFrame.this.jMenuItemChooseLevelActionPerformed(evt);
            }
        });
        this.jMenuLevel.add(this.jMenuItemChooseLevel);
        this.jMenuItemRestartLevel.setText("Restart Level");
        this.jMenuItemRestartLevel.setEnabled(false);
        this.jMenuItemRestartLevel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LemminiFrame.this.jMenuItemRestartLevelActionPerformed(evt);
            }
        });
        this.jMenuLevel.add(this.jMenuItemRestartLevel);
        this.jMenuItemLoadReplay.setText("Load Replay...");
        this.jMenuItemLoadReplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LemminiFrame.this.jMenuItemLoadReplayActionPerformed(evt);
            }
        });
        this.jMenuLevel.add(this.jMenuItemLoadReplay);
        this.jMenuItemEnterLevelCode.setText("Enter Level Code...");
        this.jMenuItemEnterLevelCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LemminiFrame.this.jMenuItemEnterLevelCodeActionPerformed(evt);
            }
        });
        this.jMenuLevel.add(this.jMenuItemEnterLevelCode);
        this.jMenuBarMain.add(this.jMenuLevel);
        this.jMenuOptions.setText("Options");
        this.jMenuItemOptions.setText("Options...");
        this.jMenuItemOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LemminiFrame.this.jMenuItemOptionsActionPerformed(evt);
            }
        });
        this.jMenuItemHotkeys.setText("Hotkeys...");
        this.jMenuItemHotkeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LemminiFrame.this.handleHotkeys();
            }
        });
        this.jMenuItemAbout.setText("About...");
        this.jMenuItemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LemminiFrame.this.handleAbout();
            }
        });
        this.jMenuOptions.add(this.jMenuItemOptions);
        this.jMenuOptions.add(this.jMenuItemHotkeys);
        this.jMenuOptions.add(this.jMenuItemAbout);
        this.jMenuBarMain.add(this.jMenuOptions);
        this.setJMenuBar(this.jMenuBarMain);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.lemminiPanelMain, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lemminiPanelMain, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    void handleHotkeys() {
        String hotkeyList = "<html><body><h3>Hotkeys</h3><table border='0' cellspacing='0'><tr><td><b>F1 | Minus(-)</b></td>                      <td>Decrease RR (press twice to jump to min)</td></tr><tr><td><b>F2 | Plus(+) | Equals(=)</b></td>           <td>Increase RR (press twice to jump to max)</td></tr><tr><td><b>F3-F10 / 1-8</b></td>                       <td>Select Skill (same order as panel buttons)</td></tr><tr><td><b>F11 | Space | P</b></td>                    <td>Pause/Resume</td></tr><tr><td><b>F12</b></td>                                <td>Nuke Level</td></tr><tr><td><b>Ctrl + R</b></td>                           <td>Restart Level</td></tr><tr><td><b>S</b></td>                                  <td>Toggle Vertical Lock</td></tr><tr><td><b>F</b></td>                                  <td>Fast-Forward</td></tr><tr><td><b>G</b></td>                                  <td>Turbo-Forward</td></tr><tr><td><b>X</b></td>                                  <td>Cancel Replay</td></tr><tr><td><b>V</b></td>                                  <td>Save Level As Image</td></tr><tr><td><b>(Advanced Select On) Arrows: Left</b></td>  <td>Select Left-Facing Lemming</td></tr><tr><td><b>(Advanced Select On) Arrows: Right</b></td> <td>Select Right-Facing Lemming</td></tr><tr><td><b>(Advanced Select On) Arrows: Up</b></td>    <td>Select Walker Lemming</td></tr><tr><td><b>(Advanced Select Off) Arrows: Left</b></td> <td>Nudge Level Left</td></tr><tr><td><b>(Advanced Select Off) Arrows: Right</b></td><td>Nudge Level Right</td></tr><tr><td><b>(Advanced Select Off) Arrows: Up</b></td>   <td>Nudge Level Up</td></tr><tr><td><b>(Advanced Select Off) Arrows: Down</b></td> <td>Nudge Level Down</td></tr><tr><td><b>Ctrl + S</b></td>                           <td>Save Replay (from Level/Debriefing)</td></tr><tr><td><b>Ctrl + L</b></td>                           <td>Load Replay</td></tr><tr><td><b>Ctrl + F4</b></td>                          <td>Manage Players</td></tr><tr><td><b>Ctrl + F5</b></td>                          <td>Enter Code</td></tr><tr><td><b>Ctrl + F9</b></td>                          <td>Select Level</td></tr><tr><td><b>Ctrl + F10</b></td>                         <td>Options</td></tr><tr><td><b>Ctrl + F11</b></td>                         <td>Hotkeys</td></tr><tr><td><b>Ctrl + F12</b></td>                         <td>About</td></tr><tr><td><b>Ctrl + M</b></td>                           <td>Toggle Menu Bar Visibility</td></tr><tr><td><b>Esc</b></td>                                <td>Quit Level / Close RetroLemmini (from Menu)</td></tr></table></body></html>";
        JOptionPane.showMessageDialog(thisFrame, hotkeyList, "Hotkeys", -1);
    }

    void handleAbout() {
        String urlLemmini = "http://lemmini.de";
        String urlForumBoard = "https://www.lemmingsforums.net/index.php?board=10.0";
        String urlRetroLemmini = "https://www.lemmingsforums.net/index.php?topic=7030.0";
        JEditorPane editorPane = new JEditorPane("text/html", "<html>RetroLemmini Version 2.3<br>By William James<br><br>Based on<br><br>SuperLemminiToo by Charles Irwin<br>SuperLemmini by Ryan Sakowski<br>Original Lemmini by Volker Oth<br><br>Get the latest version of RetroLemmini here: <a href='" + urlRetroLemmini + "'>" + "RetroLemmini on LemmingsForums.net" + "</a><br>" + "Join the Forum discussion here: <a href='" + urlForumBoard + "'>" + "Discussion board on LemmingsForums.net" + "</a><br>" + "Lemmini website: <a href='" + urlLemmini + "'>" + urlLemmini + "</a><br><br>" + "Revision Commit ID: " + LemminiFrame.getGitCommitSHA(7) + "</a><br>" + "Java Version: " + System.getProperty("java.version") + "</html>");
        editorPane.setEditable(false);
        editorPane.setBackground(new JLabel().getBackground());
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        JOptionPane.showConfirmDialog(thisFrame, new JScrollPane(editorPane), "About", -1, -1);
    }

    public static String getGitCommitSHA(Integer length) {
        String refPath;
        List<String> refLines;
        List<String> lines;
        block4: {
            try {
                lines = Files.readAllLines(Paths.get(".git/HEAD", new String[0]));
                if (!lines.isEmpty()) break block4;
                return "Unknown Commit SHA";
            }
            catch (IOException e) {
                e.printStackTrace();
                return "611ee17ebb3a6c2f01d742079de6aa5d617df467";
            }
        }
        String headRef = lines.get(0).trim();
        String commitSHA = headRef.startsWith("ref: ") ? ((refLines = Files.readAllLines(Paths.get(refPath = ".git/" + headRef.substring(5), new String[0]))).isEmpty() ? "611ee17ebb3a6c2f01d742079de6aa5d617df467" : refLines.get(0).trim()) : headRef;
        if (length == null || length <= 0 || length >= 40) {
            return commitSHA;
        }
        return commitSHA.length() > length ? commitSHA.substring(0, length) : commitSHA;
    }

    private void formComponentMoved(ComponentEvent evt) {
        this.storeUnmaximizedPos();
    }

    private void togglePause() {
        boolean isPaused = GameController.isPaused();
        if (GameController.isOptionEnabled(GameController.Option.PAUSE_STOPS_FAST_FORWARD) && !isPaused && GameController.isFastForward()) {
            GameController.setFastForward(false);
            GameController.pressIcon(Icons.IconType.FFWD);
        }
        GameController.setPaused(!isPaused);
        GameController.pressIcon(Icons.IconType.PAUSE);
    }

    private void printLevelNameToConsole() {
        System.out.println(GameController.getLevelPack(GameController.getCurLevelPackIdx()).getInfo(GameController.getCurRating(), GameController.getCurLevelNumber()).getLevelResource());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void formKeyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        switch (code) {
            case 16: {
                this.lemminiPanelMain.setShiftPressed(true);
                break;
            }
            case 17: {
                this.lemminiPanelMain.setControlPressed(true);
                break;
            }
            case 18: {
                this.lemminiPanelMain.setAltPressed(true);
                break;
            }
        }
        switch (GameController.getGameState()) {
            case LEVEL: {
                block14 : switch (code) {
                    case 49: 
                    case 114: {
                        if (this.lemminiPanelMain.getDebugDraw()) {
                            this.lemminiPanelMain.setDrawBrushSize(1);
                            break;
                        }
                        GameController.handleIconButton(Icons.IconType.CLIMB);
                        break;
                    }
                    case 50: 
                    case 115: {
                        if (this.lemminiPanelMain.isControlPressed()) {
                            this.lemminiPanelMain.handlePlayers();
                            break;
                        }
                        if (this.lemminiPanelMain.getDebugDraw()) {
                            this.lemminiPanelMain.setDrawBrushSize(2);
                            break;
                        }
                        GameController.handleIconButton(Icons.IconType.FLOAT);
                        break;
                    }
                    case 51: 
                    case 116: {
                        if (this.lemminiPanelMain.isControlPressed()) {
                            this.lemminiPanelMain.handleEnterCode();
                            break;
                        }
                        if (this.lemminiPanelMain.getDebugDraw()) {
                            this.lemminiPanelMain.setDrawBrushSize(3);
                            break;
                        }
                        GameController.handleIconButton(Icons.IconType.BOMB);
                        break;
                    }
                    case 52: 
                    case 117: {
                        if (this.lemminiPanelMain.getDebugDraw()) {
                            this.lemminiPanelMain.setDrawBrushSize(4);
                            break;
                        }
                        GameController.handleIconButton(Icons.IconType.BLOCK);
                        break;
                    }
                    case 53: 
                    case 118: {
                        if (this.lemminiPanelMain.getDebugDraw()) {
                            this.lemminiPanelMain.setDrawBrushSize(5);
                            break;
                        }
                        GameController.handleIconButton(Icons.IconType.BUILD);
                        break;
                    }
                    case 54: 
                    case 119: {
                        if (this.lemminiPanelMain.getDebugDraw()) {
                            this.lemminiPanelMain.setDrawBrushSize(6);
                            break;
                        }
                        GameController.handleIconButton(Icons.IconType.BASH);
                        break;
                    }
                    case 55: 
                    case 120: {
                        if (this.lemminiPanelMain.isControlPressed()) {
                            this.lemminiPanelMain.handleChooseLevel();
                            break;
                        }
                        if (this.lemminiPanelMain.getDebugDraw()) {
                            this.lemminiPanelMain.setDrawBrushSize(7);
                            break;
                        }
                        GameController.handleIconButton(Icons.IconType.MINE);
                        break;
                    }
                    case 56: 
                    case 121: {
                        if (this.lemminiPanelMain.isControlPressed()) {
                            this.lemminiPanelMain.handleOptions();
                            break;
                        }
                        if (this.lemminiPanelMain.getDebugDraw()) {
                            this.lemminiPanelMain.setDrawBrushSize(8);
                            break;
                        }
                        GameController.handleIconButton(Icons.IconType.DIG);
                        break;
                    }
                    case 57: {
                        if (!this.lemminiPanelMain.getDebugDraw()) break;
                        this.lemminiPanelMain.setDrawBrushSize(9);
                        break;
                    }
                    case 48: {
                        if (!this.lemminiPanelMain.getDebugDraw()) break;
                        this.lemminiPanelMain.setDrawBrushSize(10);
                        break;
                    }
                    case 122: {
                        if (this.lemminiPanelMain.isControlPressed()) {
                            this.handleHotkeys();
                            break;
                        }
                        this.togglePause();
                        break;
                    }
                    case 123: {
                        if (this.lemminiPanelMain.isControlPressed()) {
                            this.handleAbout();
                            break;
                        }
                        GameController.handleIconButton(Icons.IconType.NUKE);
                        break;
                    }
                    case 76: {
                        if (this.lemminiPanelMain.isControlPressed()) {
                            this.lemminiPanelMain.handleLoadReplay();
                            break;
                        }
                        if (!Core.player.isDebugMode()) break;
                        this.printLevelNameToConsole();
                        break;
                    }
                    case 77: {
                        if (this.lemminiPanelMain.isControlPressed()) {
                            GameController.setOption(GameController.RetroLemminiOption.SHOW_MENU_BAR, !GameController.isOptionEnabled(GameController.RetroLemminiOption.SHOW_MENU_BAR));
                            this.toggleMenuBarVisibility();
                            Core.saveSettings();
                            break;
                        }
                        this.toggleMusic();
                        break;
                    }
                    case 90: {
                        this.toggleSound();
                        break;
                    }
                    case 68: {
                        if (this.lemminiPanelMain.isControlPressed() && this.lemminiPanelMain.isAltPressed()) {
                            Core.player.setDebugMode(!Core.player.isDebugMode());
                            GameController.setWasCheated(true);
                            break;
                        }
                        if (this.lemminiPanelMain.isControlPressed() || this.lemminiPanelMain.isShiftPressed() || this.lemminiPanelMain.isAltPressed() || !Core.player.isDebugMode()) break;
                        this.lemminiPanelMain.setDebugDraw(!this.lemminiPanelMain.getDebugDraw());
                        break;
                    }
                    case 69: {
                        if (!this.lemminiPanelMain.isControlPressed() || !this.lemminiPanelMain.isAltPressed()) break;
                        Core.player.setMaximumExitPhysics(!Core.player.isMaximumExitPhysics());
                        GameController.setWasCheated(true);
                        break;
                    }
                    case 87: {
                        if (!Core.player.isDebugMode()) break;
                        GameController.setNumExited(GameController.getNumLemmingsMax());
                        GameController.endLevel();
                        break;
                    }
                    case 73: {
                        this.lemminiPanelMain.setDebugCursorInfo(!this.lemminiPanelMain.debugCursorInfoVisible());
                    }
                    case 83: {
                        if (this.lemminiPanelMain.isControlPressed()) {
                            this.lemminiPanelMain.handleSaveReplay();
                        }
                        GameController.setVerticalLock(!GameController.isVerticalLock());
                        GameController.pressIcon(Icons.IconType.VLOCK);
                        break;
                    }
                    case 86: {
                        this.saveLevelAsImage();
                        break;
                    }
                    case 85: {
                        if (!Core.player.isDebugMode()) break;
                        GameController.setSuperLemming(!GameController.isSuperLemming());
                        break;
                    }
                    case 88: {
                        GameController.stopReplayMode();
                        break;
                    }
                    case 32: 
                    case 80: {
                        this.togglePause();
                        break;
                    }
                    case 10: 
                    case 70: {
                        GameController.setTurbo(false);
                        GameController.setFastForward(!GameController.isFastForward());
                        GameController.pressIcon(Icons.IconType.FFWD);
                        break;
                    }
                    case 71: {
                        GameController.setTurbo(true);
                        GameController.setFastForward(!GameController.isFastForward());
                        GameController.pressIcon(Icons.IconType.FFWD);
                        break;
                    }
                    case 84: {
                        if (!Core.player.isDebugMode()) break;
                        GameController.setTimed(!GameController.isTimed());
                        break;
                    }
                    case 82: {
                        if (!this.lemminiPanelMain.isControlPressed() || this.lemminiPanelMain.isShiftPressed()) break;
                        GameController.requestRestartLevel(true, false);
                        break;
                    }
                    case 39: {
                        if (GameController.isOptionEnabled(GameController.Option.ADVANCED_SELECT)) {
                            if (LemmCursor.getType().isWalkerOnly()) {
                                this.lemminiPanelMain.setCursor(LemmCursor.CursorType.WALKER_RIGHT);
                                break;
                            }
                            this.lemminiPanelMain.setCursor(LemmCursor.CursorType.RIGHT);
                            break;
                        }
                        this.lemminiPanelMain.setRightPressed(true);
                        break;
                    }
                    case 37: {
                        if (GameController.isOptionEnabled(GameController.Option.ADVANCED_SELECT)) {
                            if (LemmCursor.getType().isWalkerOnly()) {
                                this.lemminiPanelMain.setCursor(LemmCursor.CursorType.WALKER_LEFT);
                                break;
                            }
                            this.lemminiPanelMain.setCursor(LemmCursor.CursorType.LEFT);
                            break;
                        }
                        this.lemminiPanelMain.setLeftPressed(true);
                        break;
                    }
                    case 38: {
                        if (GameController.isOptionEnabled(GameController.Option.ADVANCED_SELECT)) {
                            switch (LemmCursor.getType()) {
                                case NORMAL: {
                                    this.lemminiPanelMain.setCursor(LemmCursor.CursorType.WALKER);
                                    break block14;
                                }
                                case LEFT: {
                                    this.lemminiPanelMain.setCursor(LemmCursor.CursorType.WALKER_LEFT);
                                    break block14;
                                }
                                case RIGHT: {
                                    this.lemminiPanelMain.setCursor(LemmCursor.CursorType.WALKER_RIGHT);
                                    break block14;
                                }
                            }
                            break;
                        }
                        this.lemminiPanelMain.setUpPressed(true);
                        break;
                    }
                    case 40: {
                        if (GameController.isOptionEnabled(GameController.Option.ADVANCED_SELECT)) break;
                        this.lemminiPanelMain.setDownPressed(true);
                        break;
                    }
                    case 78: {
                        if (!Core.player.isDebugMode()) break;
                        Lemming l = new Lemming(this.lemminiPanelMain.getCursorX(), this.lemminiPanelMain.getCursorY(), Lemming.Direction.RIGHT);
                        GameController.addLemming(l);
                        Vsfx v = new Vsfx(this.lemminiPanelMain.getCursorX(), this.lemminiPanelMain.getCursorY(), Vsfx.Vsfx_Index.YIPPEE);
                        GameController.addVsfx(v);
                        break;
                    }
                    case 61: 
                    case 107: 
                    case 113: 
                    case 521: {
                        GameController.pressPlus(2);
                        break;
                    }
                    case 45: 
                    case 109: 
                    case 112: {
                        GameController.pressMinus(2);
                        break;
                    }
                    case 27: {
                        GameController.endLevel();
                        break;
                    }
                }
                evt.consume();
                return;
            }
            case BRIEFING: {
                switch (code) {
                    case 10: 
                    case 32: {
                        this.lemminiPanelMain.startLevel();
                        return;
                    }
                    case 76: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.lemminiPanelMain.handleLoadReplay();
                        return;
                    }
                    case 77: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        GameController.setOption(GameController.RetroLemminiOption.SHOW_MENU_BAR, !GameController.isOptionEnabled(GameController.RetroLemminiOption.SHOW_MENU_BAR));
                        this.toggleMenuBarVisibility();
                        Core.saveSettings();
                        return;
                    }
                    case 115: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.lemminiPanelMain.handlePlayers();
                        return;
                    }
                    case 120: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.lemminiPanelMain.handleChooseLevel();
                        return;
                    }
                    case 116: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.lemminiPanelMain.handleEnterCode();
                        return;
                    }
                    case 121: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.lemminiPanelMain.handleOptions();
                        return;
                    }
                    case 122: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.handleHotkeys();
                        return;
                    }
                    case 123: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.handleAbout();
                        return;
                    }
                    case 37: {
                        if (Fader.getState() != Fader.State.OFF) return;
                        LevelPack pack = GameController.getCurLevelPack();
                        String packName = pack.getName();
                        int packIdx = GameController.getCurLevelPackIdx();
                        List<String> ratings = pack.getRatings();
                        int rating = GameController.getCurRating();
                        int lvlNum = GameController.getCurLevelNumber() - 1;
                        block102: while (true) {
                            if (rating < 0) {
                                return;
                            }
                            while (true) {
                                if (lvlNum < 0) {
                                    if (--rating < 0) continue block102;
                                    lvlNum = pack.getLevelCount(rating) - 1;
                                    continue block102;
                                }
                                if (Core.player.isAvailable(packName, ratings.get(rating), lvlNum)) {
                                    GameController.requestChangeLevel(packIdx, rating, lvlNum, false);
                                    return;
                                }
                                --lvlNum;
                            }
                            break;
                        }
                    }
                    case 39: {
                        if (Fader.getState() != Fader.State.OFF) return;
                        LevelPack pack = GameController.getCurLevelPack();
                        String packName = pack.getName();
                        int packIdx = GameController.getCurLevelPackIdx();
                        List<String> ratings = pack.getRatings();
                        int rating = GameController.getCurRating();
                        int lvlCount = pack.getLevelCount(rating);
                        int lvlNum = GameController.getCurLevelNumber() + 1;
                        block104: while (true) {
                            if (rating >= ratings.size()) {
                                return;
                            }
                            while (true) {
                                if (lvlNum >= lvlCount) {
                                    if (++rating >= ratings.size()) continue block104;
                                    lvlNum = 0;
                                    continue block104;
                                }
                                if (Core.player.isAvailable(packName, ratings.get(rating), lvlNum)) {
                                    GameController.requestChangeLevel(packIdx, rating, lvlNum, false);
                                    return;
                                }
                                ++lvlNum;
                            }
                            break;
                        }
                    }
                    case 38: {
                        if (Fader.getState() != Fader.State.OFF) return;
                        LevelPack pack = GameController.getCurLevelPack();
                        String packName = pack.getName();
                        int packIdx = GameController.getCurLevelPackIdx();
                        List<String> ratings = pack.getRatings();
                        int rating = GameController.getCurRating() - 1;
                        int lvlNum = GameController.getCurLevelNumber();
                        block106: while (true) {
                            if (rating < 0) {
                                return;
                            }
                            while (true) {
                                if (lvlNum < 0) {
                                    if (--rating < 0) continue block106;
                                    lvlNum = Math.min(pack.getLevelCount(rating), GameController.getCurLevelNumber());
                                    continue block106;
                                }
                                if (Core.player.isAvailable(packName, ratings.get(rating), lvlNum)) {
                                    GameController.requestChangeLevel(packIdx, rating, lvlNum, false);
                                    return;
                                }
                                --lvlNum;
                            }
                            break;
                        }
                    }
                    case 40: {
                        if (Fader.getState() == Fader.State.OFF) {
                            LevelPack pack = GameController.getCurLevelPack();
                            String packName = pack.getName();
                            int packIdx = GameController.getCurLevelPackIdx();
                            List<String> ratings = pack.getRatings();
                            int rating = GameController.getCurRating() + 1;
                            int lvlNum = GameController.getCurLevelNumber();
                            block108: while (rating < ratings.size()) {
                                while (true) {
                                    if (lvlNum < 0) {
                                        if (++rating >= ratings.size()) continue block108;
                                        lvlNum = Math.min(pack.getLevelCount(rating), GameController.getCurLevelNumber());
                                        continue block108;
                                    }
                                    if (Core.player.isAvailable(packName, ratings.get(rating), lvlNum)) {
                                        GameController.requestChangeLevel(packIdx, rating, lvlNum, false);
                                        return;
                                    }
                                    --lvlNum;
                                }
                            }
                        }
                    }
                    case 27: {
                        this.lemminiPanelMain.exitToMenu();
                        return;
                    }
                }
                return;
            }
            case INTRO: {
                switch (code) {
                    case 27: {
                        this.exit();
                        return;
                    }
                    case 10: 
                    case 32: {
                        this.lemminiPanelMain.loadDefaultLevel();
                        return;
                    }
                    case 76: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.lemminiPanelMain.handleLoadReplay();
                        return;
                    }
                    case 77: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        GameController.setOption(GameController.RetroLemminiOption.SHOW_MENU_BAR, !GameController.isOptionEnabled(GameController.RetroLemminiOption.SHOW_MENU_BAR));
                        this.toggleMenuBarVisibility();
                        Core.saveSettings();
                        return;
                    }
                    case 115: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.lemminiPanelMain.handlePlayers();
                        return;
                    }
                    case 120: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.lemminiPanelMain.handleChooseLevel();
                        return;
                    }
                    case 116: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.lemminiPanelMain.handleEnterCode();
                        return;
                    }
                    case 121: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.lemminiPanelMain.handleOptions();
                        return;
                    }
                    case 122: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.handleHotkeys();
                        return;
                    }
                    case 123: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.handleAbout();
                        return;
                    }
                }
                return;
            }
            case DEBRIEFING: 
            case LEVEL_END: {
                switch (code) {
                    case 10: 
                    case 32: {
                        this.lemminiPanelMain.findBestLevelToLoad();
                        return;
                    }
                    case 76: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.lemminiPanelMain.handleLoadReplay();
                        return;
                    }
                    case 77: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        GameController.setOption(GameController.RetroLemminiOption.SHOW_MENU_BAR, !GameController.isOptionEnabled(GameController.RetroLemminiOption.SHOW_MENU_BAR));
                        this.toggleMenuBarVisibility();
                        Core.saveSettings();
                        return;
                    }
                    case 115: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.lemminiPanelMain.handlePlayers();
                        return;
                    }
                    case 120: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.lemminiPanelMain.handleChooseLevel();
                        return;
                    }
                    case 116: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.lemminiPanelMain.handleEnterCode();
                        return;
                    }
                    case 121: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.lemminiPanelMain.handleOptions();
                        return;
                    }
                    case 122: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.handleHotkeys();
                        return;
                    }
                    case 123: {
                        if (!this.lemminiPanelMain.isControlPressed()) return;
                        this.handleAbout();
                        return;
                    }
                    case 86: {
                        LemmImage tmp = GameController.getLevel().createMinimap(GameController.getFgImage(), 1.0, 1.0, true, false, true);
                        try {
                            Throwable throwable = null;
                            Object var5_21 = null;
                            try {
                                OutputStream out = Core.resourceTree.newOutputStream("level.png", new OpenOption[0]);
                                try {
                                    ImageIO.write((RenderedImage)tmp.getImage(), "png", out);
                                    if (out == null) return;
                                }
                                catch (Throwable throwable2) {
                                    if (out == null) throw throwable2;
                                    out.close();
                                    throw throwable2;
                                }
                                out.close();
                                return;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                    throw throwable;
                                }
                                if (throwable == throwable3) throw throwable;
                                throwable.addSuppressed(throwable3);
                                throw throwable;
                            }
                        }
                        catch (IOException iOException) {
                            return;
                        }
                    }
                    case 83: {
                        if (this.lemminiPanelMain.isControlPressed()) {
                            this.lemminiPanelMain.handleSaveReplay();
                        }
                    }
                    case 27: {
                        this.lemminiPanelMain.exitToMenu();
                        return;
                    }
                }
                return;
            }
        }
    }

    private void formKeyReleased(KeyEvent evt) {
        int code = evt.getKeyCode();
        if (GameController.getGameState() == GameController.State.LEVEL) {
            block0 : switch (code) {
                case 16: {
                    this.lemminiPanelMain.setShiftPressed(false);
                    break;
                }
                case 17: {
                    this.lemminiPanelMain.setControlPressed(false);
                    break;
                }
                case 18: {
                    this.lemminiPanelMain.setAltPressed(false);
                    break;
                }
                case 61: 
                case 107: 
                case 113: 
                case 521: {
                    GameController.releasePlus(2);
                    break;
                }
                case 45: 
                case 109: 
                case 112: {
                    GameController.releaseMinus(2);
                    break;
                }
                case 123: {
                    GameController.releaseIcon(Icons.IconType.NUKE);
                    break;
                }
                case 37: {
                    if (GameController.isOptionEnabled(GameController.Option.ADVANCED_SELECT)) {
                        if (LemmCursor.getType() == LemmCursor.CursorType.LEFT) {
                            this.lemminiPanelMain.setCursor(LemmCursor.CursorType.NORMAL);
                            break;
                        }
                        if (LemmCursor.getType() != LemmCursor.CursorType.WALKER_LEFT) break;
                        this.lemminiPanelMain.setCursor(LemmCursor.CursorType.WALKER);
                        break;
                    }
                    this.lemminiPanelMain.setLeftPressed(false);
                    break;
                }
                case 39: {
                    if (GameController.isOptionEnabled(GameController.Option.ADVANCED_SELECT)) {
                        if (LemmCursor.getType() == LemmCursor.CursorType.RIGHT) {
                            this.lemminiPanelMain.setCursor(LemmCursor.CursorType.NORMAL);
                            break;
                        }
                        if (LemmCursor.getType() != LemmCursor.CursorType.WALKER_RIGHT) break;
                        this.lemminiPanelMain.setCursor(LemmCursor.CursorType.WALKER);
                        break;
                    }
                    this.lemminiPanelMain.setRightPressed(false);
                    break;
                }
                case 38: {
                    if (GameController.isOptionEnabled(GameController.Option.ADVANCED_SELECT)) {
                        switch (LemmCursor.getType()) {
                            case WALKER: {
                                this.lemminiPanelMain.setCursor(LemmCursor.CursorType.NORMAL);
                                break block0;
                            }
                            case WALKER_LEFT: {
                                this.lemminiPanelMain.setCursor(LemmCursor.CursorType.LEFT);
                                break block0;
                            }
                            case WALKER_RIGHT: {
                                this.lemminiPanelMain.setCursor(LemmCursor.CursorType.RIGHT);
                                break block0;
                            }
                        }
                        break;
                    }
                    this.lemminiPanelMain.setUpPressed(false);
                    break;
                }
                case 40: {
                    if (GameController.isOptionEnabled(GameController.Option.ADVANCED_SELECT)) break;
                    this.lemminiPanelMain.setDownPressed(false);
                    break;
                }
            }
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        this.exit();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.exit();
    }

    private void formWindowGainedFocus(WindowEvent evt) {
        this.lemminiPanelMain.focusGained();
    }

    private void formWindowLostFocus(WindowEvent evt) {
        this.lemminiPanelMain.focusLost();
    }

    private void jMenuItemExitActionPerformed(ActionEvent evt) {
        this.exit();
    }

    private void jMenuItemManagePlayersActionPerformed(ActionEvent evt) {
        this.lemminiPanelMain.handlePlayers();
    }

    private void jMenuItemChooseLevelActionPerformed(ActionEvent evt) {
        this.lemminiPanelMain.handleChooseLevel();
    }

    private void jMenuItemRestartLevelActionPerformed(ActionEvent evt) {
        if (GameController.getLevel() == null) {
            GameController.requestChangeLevel(GameController.getCurLevelPackIdx(), GameController.getCurRating(), GameController.getCurLevelNumber(), false);
        } else {
            GameController.requestRestartLevel(false, true);
        }
    }

    private void jMenuItemLoadReplayActionPerformed(ActionEvent evt) {
        this.lemminiPanelMain.handleLoadReplay();
    }

    private void jMenuItemEnterLevelCodeActionPerformed(ActionEvent evt) {
        this.lemminiPanelMain.handleEnterCode();
    }

    private void jMenuItemOptionsActionPerformed(ActionEvent evt) {
        this.lemminiPanelMain.handleOptions();
    }

    public static void main(String[] args) throws IOException {
        try {
            ProcessBuilder pb = new ProcessBuilder("cmd", "/c", "getcommitID.bat");
            pb.start().waitFor();
        }
        catch (IOException | InterruptedException e) {
            System.err.println("Failed to run getcommitID.bat: " + e.getMessage());
            e.printStackTrace();
        }
        LemminiFrame.consoleInit();
        if (!SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_1_8)) {
            System.out.println("JVM >= 1.8 [FAIL]");
            JOptionPane.showMessageDialog(null, "RetroLemmini requires JVM 1.8 or later.", "Error", 0);
            System.exit(1);
        } else {
            System.out.println("JVM >= 1.8 [PASS]");
        }
        long free = Runtime.getRuntime().maxMemory();
        long memReq = 0x6000000L;
        if (free < memReq) {
            System.out.println("memory check: " + (int)(free / 0x100000L) + "MB >= " + (int)(memReq / 0x100000L) + "MB [FAIL]");
            JOptionPane.showMessageDialog(null, "You need at least 96MB of heap.", "Error", 0);
            System.exit(1);
        } else {
            System.out.println("memory check: " + (int)(free / 0x100000L) + "MB >= " + (int)(memReq / 0x100000L) + "MB [PASS]");
        }
        Path level = null;
        int i22 = 0;
        while (i22 < args.length) {
            switch (args[i22].toLowerCase(Locale.ROOT)) {
                case "-l": {
                    if (++i22 < args.length) {
                        level = Paths.get(args[i22], new String[0]);
                        System.out.println("argument detected: -L, but no level filename supplied.");
                        break;
                    }
                    System.out.println("argument detected: -L " + level.toString());
                    break;
                }
            }
            ++i22;
        }
        System.out.println("applying system \"Look and Feel\" and system specific settings...");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException i22) {
            // empty catch block
        }
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        new Thread(){
            {
                this.setDaemon(true);
                this.start();
            }

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(Long.MAX_VALUE);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        };
        System.out.println("\ncreating LemminiFrame...");
        thisFrame = new LemminiFrame();
        thisFrame.init();
        if (level != null) {
            System.out.println("external level loaded. starting up inside level...");
            int[] levelPosition = GameController.addExternalLevel(level, null, true);
            GameController.requestChangeLevel(levelPosition[0], levelPosition[1], levelPosition[2], false);
        }
    }

    void toggleMenuBarVisibility() {
        boolean shouldShowMenuBar = GameController.isOptionEnabled(GameController.RetroLemminiOption.SHOW_MENU_BAR);
        if (shouldShowMenuBar) {
            this.setJMenuBar(this.jMenuBarMain);
        } else {
            this.setJMenuBar(null);
        }
        this.validate();
        Insets insets = this.getInsets();
        int contentWidth = this.getWidth() - insets.left - insets.right;
        int contentHeight = this.getHeight() - insets.top - insets.bottom;
        this.setSize(contentWidth + insets.left + insets.right, contentHeight + insets.top + insets.bottom);
    }

    void toggleMusic() {
        double musicVol = GameController.getMusicGain();
        if (musicVol > 0.0) {
            this.userMusicVolume = musicVol;
        }
        if (musicVol == 0.0) {
            GameController.setMusicGain(this.userMusicVolume > 0.0 ? this.userMusicVolume : 0.5);
        } else {
            GameController.setMusicGain(0.0);
        }
    }

    void toggleSound() {
        double soundVol = GameController.getSoundGain();
        if (soundVol > 0.0) {
            this.userSoundVolume = soundVol;
        }
        if (soundVol == 0.0) {
            GameController.setSoundGain(this.userSoundVolume > 0.0 ? this.userSoundVolume : 0.5);
        } else {
            GameController.setSoundGain(0.0);
        }
    }

    void exit() {
        Music.close();
        Core.saveProgramProps();
        Core.programProps.setInt("frameWidth", this.lemminiPanelMain.getUnmaximizedWidth());
        Core.programProps.setInt("frameHeight", this.lemminiPanelMain.getUnmaximizedHeight());
        Core.programProps.setInt("framePosX", this.unmaximizedPosX);
        Core.programProps.setInt("framePosY", this.unmaximizedPosY);
        Core.programProps.setBoolean("maximizedHoriz", BooleanUtils.toBoolean((int)(this.getExtendedState() & 2)));
        Core.programProps.setBoolean("maximizedVert", BooleanUtils.toBoolean((int)(this.getExtendedState() & 4)));
        Core.programProps.save(Core.getProgramPropsFilePath(), false);
        RepeatingReleasedEventsFixer.remove();
        System.exit(0);
    }

    @Override
    public void setLocation(int x, int y) {
        super.setLocation(x, y);
        this.storeUnmaximizedPos();
    }

    private void storeUnmaximizedPos() {
        int frameState = this.getExtendedState();
        if (!BooleanUtils.toBoolean((int)(frameState & 2))) {
            this.unmaximizedPosX = this.getX();
        }
        if (!BooleanUtils.toBoolean((int)(frameState & 4))) {
            this.unmaximizedPosY = this.getY();
        }
    }

    public void setCursor(LemmCursor.CursorType c) {
        this.lemminiPanelMain.setCursor(c);
    }

    void setRestartEnabled(boolean restartEnabled) {
        this.jMenuItemRestartLevel.setEnabled(restartEnabled);
    }

    public static LemminiFrame getFrame() {
        return thisFrame;
    }

    private void saveLevelAsImage() {
        String levelName = GameController.getLevel().getLevelName();
        String baseFileName = levelName.replaceAll("[^a-zA-Z0-9._-]", "_");
        String fileName = String.valueOf(baseFileName) + ".png";
        Path filePath = Core.resourceTree.getPath(fileName);
        int counter = 1;
        while (Files.exists(filePath, new LinkOption[0])) {
            fileName = String.valueOf(baseFileName) + "(" + counter + ").png";
            filePath = Core.resourceTree.getPath(fileName);
            ++counter;
        }
        LemmImage tmp = GameController.getLevel().createMinimap(GameController.getFgImage(), 1.0, 1.0, true, false, true);
        try {
            Throwable throwable = null;
            Object var8_10 = null;
            try (OutputStream out = Files.newOutputStream(filePath, StandardOpenOption.CREATE_NEW);){
                ImageIO.write((RenderedImage)tmp.getImage(), "png", out);
                out.flush();
                JOptionPane.showMessageDialog(null, "Level image successfully saved to\n" + filePath, "Save Level Image", -1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "Could not save level image", "Save Level Image", 0);
        }
    }
}

