/*
 * Decompiled with CFR 0.152.
 */
package keyrepeatfix;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Timer;

public class RepeatingReleasedEventsFixer
implements AWTEventListener {
    private final Map<Integer, ReleasedAction> _map = new HashMap<Integer, ReleasedAction>();
    private static RepeatingReleasedEventsFixer installed;
    private static final Object INSTALLED_SYNC;

    static {
        INSTALLED_SYNC = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install() {
        Object object = INSTALLED_SYNC;
        synchronized (object) {
            if (installed == null) {
                installed = new RepeatingReleasedEventsFixer();
                Toolkit.getDefaultToolkit().addAWTEventListener(installed, 8L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove() {
        Object object = INSTALLED_SYNC;
        synchronized (object) {
            if (installed != null) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(installed);
                installed = null;
            }
        }
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        assert (event instanceof KeyEvent) : "Shall only listen to KeyEvents, so no other events shall come here";
        assert (RepeatingReleasedEventsFixer.assertEDT());
        if (event instanceof Reposted) {
            return;
        }
        if (event.getID() == 400) {
            return;
        }
        KeyEvent keyEvent = (KeyEvent)event;
        if (keyEvent.isConsumed()) {
            return;
        }
        switch (keyEvent.getID()) {
            case 402: {
                Timer timer = new Timer(2, null);
                ReleasedAction action = new ReleasedAction(keyEvent, timer);
                timer.addActionListener(action);
                timer.start();
                this._map.put(keyEvent.getKeyCode(), action);
                keyEvent.consume();
                break;
            }
            case 401: {
                ReleasedAction action = this._map.remove(keyEvent.getKeyCode());
                if (action == null) break;
                action.cancel();
                break;
            }
            default: {
                throw new AssertionError((Object)"All IDs should be covered.");
            }
        }
    }

    private static boolean assertEDT() {
        if (!EventQueue.isDispatchThread()) {
            throw new AssertionError((Object)("Not EDT, but [" + Thread.currentThread() + "]."));
        }
        return true;
    }

    private class ReleasedAction
    implements ActionListener {
        private final KeyEvent _originalKeyEvent;
        private Timer _timer;

        ReleasedAction(KeyEvent originalReleased, Timer timer) {
            this._timer = timer;
            this._originalKeyEvent = originalReleased;
        }

        void cancel() {
            assert (RepeatingReleasedEventsFixer.assertEDT());
            this._timer.stop();
            this._timer = null;
            RepeatingReleasedEventsFixer.this._map.remove(this._originalKeyEvent.getKeyCode());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (RepeatingReleasedEventsFixer.assertEDT());
            if (this._timer == null) {
                return;
            }
            this.cancel();
            RepostedKeyEvent newEvent = new RepostedKeyEvent((Component)this._originalKeyEvent.getSource(), this._originalKeyEvent.getID(), this._originalKeyEvent.getWhen(), this._originalKeyEvent.getModifiersEx(), this._originalKeyEvent.getKeyCode(), this._originalKeyEvent.getKeyChar(), this._originalKeyEvent.getKeyLocation());
            Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(newEvent);
        }
    }

    public static interface Reposted {
    }

    public static class RepostedKeyEvent
    extends KeyEvent
    implements Reposted {
        private static final long serialVersionUID = 1L;

        public RepostedKeyEvent(Component source, int id, long when, int modifiers, int keyCode, char keyChar, int keyLocation) {
            super(source, id, when, modifiers, keyCode, keyChar, keyLocation);
        }
    }
}

