unit wsmain;

interface

uses
  OpenSaveDlgs, Gr32,
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TFrameInfoRec = packed record
    xOffset: Word;
    yOffset: Word;
    maxDataWidth: Word;
    dataHeight: Word;
    imageWidth: Word;
    imageHeight: Word;
  end;

  TForm1 = class(TForm)
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
  private
    fSprStream: TFileStream;
    fPalStream: TFileStream;
    fPal: Array[0..255] of TColor32;
    fNumFrames: Word;
    fStartLoc: Word;
    function LoadPalette: Boolean;
    function CheckHeader: Boolean;
    procedure GetInitData;
    procedure GetImages;
  public
    constructor Create(aOwner: TComponent); override;
    procedure DoExtract;
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

constructor TForm1.Create(aOwner: TComponent);
begin
  inherited;
end;

procedure TForm1.DoExtract;
var
  s, os: String;
begin
s := OpenDialog('SPR File|*.spr');
  if s = '' then Halt(0);
  os := ExtractFileName(ChangeFileExt(s, ''));
  fSprStream := TFileStream.Create(s, fmOpenRead);
  if not CheckHeader then
  begin
    ShowMessage('This is not a valid WinLemm SPR file.');
    Halt(0);
  end else begin
    s := ChangeFileExt(s, '.pal');
    if not FileExists(s) then
    begin
      ShowMessage('Please select palette file.');
      s := OpenDialog('PAL File|*.pal');
      if s = '' then Halt(0);
    end;
    fPalStream := TFileStream.Create(s, fmOpenRead);
    if not LoadPalette then
    begin
      ShowMessage('Palette file is invalid.');
      Halt(0);
    end;
  end;
  if MessageDlg('Click OK to begin extraction.', mtCustom, [mbOk, mbCancel], 0) = mrCancel then Halt(0);
  if not ForceDirectories(ExtractFilePath(ParamStr(0)) + os) then
  begin
    ShowMessage('Error creating output directory.');
    Exit;
  end;
  SetCurrentDir(ExtractFilePath(ParamStr(0)) + os);
  GetInitData;
  GetImages;
  ShowMessage('Done!');
end;

function TForm1.LoadPalette: Boolean;
var
  CA: Array[0..3] of Char;
  mc: Word;
  i: Integer;
  li: Integer;
  lw: LongWord;
  PatchIt: Boolean;
begin
  for i := 0 to 255 do
    fPal[i] := 0;
  try
    fPalStream.Seek(0, soFromBeginning);
    fPalStream.Read(CA, 4);
    if CA <> ' LAP' then
    begin
      Result := false;
      Exit;
    end;
    fPalStream.Read(mc, 2);
    PatchIt := mc <= $80;
    i := 0;
    for li := 1 to mc do
    begin
      fPalStream.Read(lw, 4);
      fPal[i] := ((lw and $FF) shl 16) + (lw and $FF00) + ((lw and $FF0000) shr 16) + $FF000000;
      if PatchIt then fPal[i+$80] := fPal[i];
      i := i + 1;
    end;
    Result := true;
  except
    Result := false;
  end;
end;

function TForm1.CheckHeader: Boolean;
var
  CA: Array[0..3] of Char;
begin
  try
    fSprStream.Seek(0, soFromBeginning);
    fSprStream.ReadBuffer(CA, 4);
    Result := CA = 'SRLE';
  except
    Result := false;
  end;
end;

procedure TForm1.GetInitData;
begin
  fSprStream.Seek(4, soFromBeginning);
  fSprStream.Read(fNumFrames, 2);
  fSprStream.Read(fStartLoc, 2);
end;

procedure TForm1.GetImages;
var
  i: Integer;
  InfRec: TFrameInfoRec;
  TempBmp: TBitmap32;
  b: Byte;

  Line: Integer;
  XPos: Integer;
  YPos: Integer;
  LineLen: Integer;
  CurPix: Integer;

  function LeadZeroStr(aVal, aLen: Integer): String; // why the fuck is this not a built-in command? I seem to use it in EVERY app I write...
  begin
    Result := IntToStr(aVal);
    while Length(Result) < aLen do
      Result := '0' + Result;
  end;

begin
  fSprStream.Seek(fStartLoc, soFromBeginning);
  TempBmp := TBitmap32.Create;
  for i := 0 to fNumFrames - 1 do
  begin
    fSprStream.Read(InfRec, SizeOf(InfRec));
    TempBmp.SetSize(InfRec.imageWidth, InfRec.imageHeight);
    TempBmp.Clear(0);

    for Line := 1 to InfRec.dataHeight do
    begin
      YPos := (Line - 1) + InfRec.yOffset;
      XPos := InfRec.xOffset;
      fSprStream.Read(b, 1);
      repeat
        if b < $80 then
        begin
          XPos := XPos + b;
          while b = $7F do
          begin
            fSprStream.Read(b, 1);
            XPos := XPos + b;
          end;
          fSprStream.Read(b, 1);
        end;
        if b = $80 then Break;

        LineLen := b - $80;

        for CurPix := 0 to LineLen-1 do
        begin
          fSprStream.Read(b, 1);
          TempBmp.Pixel[XPos, YPos] := fPal[b];
          XPos := XPos + 1;
        end;

        fSprStream.Read(b, 1);
      until b = $80;
    end;

    TempBmp.SaveToFile('image_' + LeadZeroStr(i, 3) + '.bmp');

  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  DoExtract;
  Halt(0);
end;

end.
