﻿using System.Text;

internal class Program
{
    private const int SPACING = 6;

    private static bool CheckKoan(string koan)
    {
        // Koans are trimmed and uppercased before passing, and empty lines are skipped

        if (koan.Length < 2)
            return false;

        char firstUnique = koan[0];
        char secondUnique = koan[1];

        int firstCount = 0;
        int secondCount = 0;
        foreach (var c in koan)
        {
            if (c == firstUnique)
                firstCount++;
            if (c == secondUnique)
                secondCount++;
        }

        return firstCount < secondCount;
    }

    private static void Main()
    {
        var oldInput = File.Exists("old.txt") ? File.ReadAllLines("old.txt").ToList() : new List<string>();
        var input = File.ReadAllLines("input.txt").Concat(oldInput).Select(k => k.Trim().ToUpperInvariant()).Where(k => !string.IsNullOrWhiteSpace(k)).Distinct().ToList();
        var white = new List<string>();
        var black = new List<string>();

        foreach (var koan in input)
        {
            if (CheckKoan(koan))
                white.Add(koan);
            else
                black.Add(koan);
        }

        foreach (var koan in oldInput)
        {
            if (!white.Contains(koan) && !black.Contains(koan))
                if (CheckKoan(koan))
                    white.Add(koan);
                else
                    black.Add(koan);

        }

        OutputLists(white, black, oldInput);
    }

    private static void OutputLists(List<string> white, List<string> black, List<string> old)
    {
        int maxCount = Math.Max(white.Count, black.Count);
        int columns = 1;
        if (maxCount >= 6)
            columns = 2;
        if (maxCount >= 18)
            columns = 3;

        white.Sort();
        black.Sort();

        int maxLength = white.Concat(black).Max(k => k.Length);

        var output = new List<string>();
        output.Add("[b][u]White Koans[/u][/b]");
        OutputList(output, white, old, columns, maxLength);
        output.Add("");
        output.Add("[b][u]Black Koans[/u][/b]");
        OutputList(output, black, old, columns, maxLength);

        if (File.Exists("notes.txt"))
        {
            output.Add("");
            output.Add("[b][u]Other notes[/u][/b]");
            output.AddRange(File.ReadAllLines("notes.txt"));
        }

        File.WriteAllLines("output.txt", output);
        File.WriteAllLines("old.txt", old);
    }

    private static void OutputList(List<string> output, List<string> list, List<string> old, int columns, int maxLength)
    {
        if (list.Count == 0)
            return;

        var line = new StringBuilder();
        var koanString = new StringBuilder();
        var outputLines = (list.Count / columns) + (list.Count % columns == 0 ? 0 : 1);

        line.Append("[tt]");

        string[,] koanGrid = new string[columns, outputLines];
        int outX = 0;
        int outY = 0;
        for (int i = 0; i < list.Count; i++)
        {
            koanGrid[outX, outY] = list[i];
            outY++;
            if (outY == outputLines)
            {
                outY = 0;
                outX++;
            }
        }

        for (int i = 0; i < columns * outputLines; i++)
        {
            var koan = koanGrid[i % columns, i / columns] ?? "";
            if (!old.Contains(koan) && !string.IsNullOrWhiteSpace(koan))
            {
                koanString.Append("* ");
                old.Add(koan);
            }
            else
                koanString.Append("  ");

            koanString.Append(koan);
            koanString.Append(' ', maxLength - koan.Length);

            line.Append(koanString);
            koanString.Clear();

            line.Append(' ', SPACING);

            if (i % columns == columns - 1 || i == columns * outputLines - 1)
            {
                var outLine = line.ToString().TrimEnd();
                if (i == columns * outputLines - 1)
                    outLine += "[/tt]";
                output.Add(outLine);
                line.Clear();
            }
        }
    }
}